/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.core.framework.config.module.WebModuleConfiguration;

public class KIMConfigurer
extends ModuleConfigurer {
    public static final String KIM_DATASOURCE_OBJ = "kim.datasource";
    private static final String KIM_UI_SPRING_BEANS_PATH = "classpath:org/kuali/rice/kim/impl/config/KimWebSpringBeans.xml";
    private DataSource dataSource;

    public KIMConfigurer() {
        super("kim");
        this.setValidRunModes(Arrays.asList(RunMode.THIN, RunMode.REMOTE, RunMode.EMBEDDED, RunMode.LOCAL));
    }

    protected String getDefaultConfigPackagePath() {
        return "classpath:org/kuali/rice/kim/impl/config/";
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info("KIMConfigurer:getPrimarySpringFiles: getRunMode => " + String.valueOf(this.getRunMode()));
        ArrayList<String> springFileLocations = new ArrayList<String>();
        if (RunMode.THIN == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KimThinSpringBeans.xml");
        } else if (RunMode.REMOTE == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KimRemoteSpringBeans.xml");
        } else if (RunMode.EMBEDDED == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KimEmbeddedSpringBeans.xml");
        } else if (RunMode.LOCAL == this.getRunMode()) {
            springFileLocations.add(this.getDefaultConfigPackagePath() + "KimLocalSpringBeans.xml");
        }
        return springFileLocations;
    }

    public void addAdditonalToConfig() {
        this.configureDataSource();
    }

    private void configureDataSource() {
        if (this.getDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject(KIM_DATASOURCE_OBJ, (Object)this.getDataSource());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean hasWebInterface() {
        return true;
    }

    protected WebModuleConfiguration loadWebModule() {
        WebModuleConfiguration configuration = super.loadWebModule();
        configuration.setWebSpringFiles(Arrays.asList(KIM_UI_SPRING_BEANS_PATH));
        return configuration;
    }
}

