/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.UberResponsibilityBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.inquiry.KimInquirableImpl;
import org.kuali.rice.kim.lookup.RoleLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectWrapper;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.uif.widget.Inquiry;

public class ResponsibilityInquirableImpl
extends KimInquirableImpl {
    private static final Logger LOG = LogManager.getLogger(ResponsibilityInquirableImpl.class);
    private static final long serialVersionUID = 1L;

    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        if ("name".equals(propertyName) || "nameToDisplay".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, UberResponsibilityBo.class, primaryKeys);
        } else if ("namespaceCode".equals(propertyName) || "template.namespaceCode".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(propertyName, "code");
            inquiry.buildInquiryLink(dataObject, propertyName, NamespaceBo.class, primaryKeys);
        } else if ("detailObjects".equals(propertyName)) {
            LOG.info("detailObjects propertyName");
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else if ("assignedToRolesToDisplay".equals(propertyName)) {
            LOG.info("assignedToRolesToDisplay propertyName");
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        }
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("name".equals(attributeName) || "nameToDisplay".equals(attributeName)) {
            return this.getInquiryUrlForPrimaryKeys(UberResponsibilityBo.class, businessObject, Collections.singletonList("id"), null);
        }
        if ("namespaceCode".equals(attributeName) || "template.namespaceCode".equals(attributeName)) {
            String code = (String)KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(attributeName);
            NamespaceBo parameterNamespace = new NamespaceBo();
            parameterNamespace.setCode(code);
            return this.getInquiryUrlForPrimaryKeys(NamespaceBo.class, parameterNamespace, Collections.singletonList("code"), null);
        }
        if (!"detailObjects".equals(attributeName) && "assignedToRolesToDisplay".equals(attributeName)) {
            return this.getAssignedRoleInquiryUrl(businessObject);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    protected HtmlData getAttributesInquiryUrl(BusinessObject businessObject, String attributeName) {
        DataObjectWrapper wrapper = KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject);
        List responsibilityAttributeData = (List)wrapper.getPropertyValueNullSafe(attributeName);
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("attributeDataId");
        for (ResponsibilityAttributeBo responsibilityAttributeDataImpl : responsibilityAttributeData) {
            htmlData.add(this.getInquiryUrlForPrimaryKeys(ResponsibilityAttributeBo.class, responsibilityAttributeDataImpl, primaryKeys, this.getKimAttributeLabelFromDD(responsibilityAttributeDataImpl.getKimAttribute().getAttributeName()) + " : " + responsibilityAttributeDataImpl.getAttributeValue()));
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    protected HtmlData getAssignedRoleInquiryUrl(BusinessObject businessObject) {
        UberResponsibilityBo responsibility = (UberResponsibilityBo)businessObject;
        List assignedToRoles = responsibility.getAssignedToRoles();
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        if (assignedToRoles != null && !assignedToRoles.isEmpty()) {
            List<String> primaryKeys = Collections.singletonList("id");
            RoleService roleService = KimApiServiceLocator.getRoleService();
            for (RoleBo roleImpl : assignedToRoles) {
                Role role = roleService.getRole(roleImpl.getId());
                HtmlData.AnchorHtmlData inquiryHtmlData = this.getInquiryUrlForPrimaryKeys(RoleBo.class, role, primaryKeys, role.getNamespaceCode() + " " + role.getName());
                inquiryHtmlData.setHref(RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref(inquiryHtmlData.getHref()));
                htmlData.add(inquiryHtmlData);
            }
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    public Object retrieveDataObject(Map fieldValues) {
        return this.getBusinessObject(fieldValues);
    }

    public BusinessObject getBusinessObject(Map fieldValues) {
        if (fieldValues.get("id") == null) {
            return null;
        }
        ResponsibilityBo responsibilityImpl = (ResponsibilityBo)this.getDataObjectService().find(ResponsibilityBo.class, (Object)fieldValues.get("id").toString());
        return this.getResponsibilitiesSearchResultsCopy(responsibilityImpl);
    }

    private UberResponsibilityBo getResponsibilitiesSearchResultsCopy(ResponsibilityBo responsibilitySearchResult) {
        UberResponsibilityBo responsibilitySearchResultCopy = new UberResponsibilityBo();
        try {
            PropertyUtils.copyProperties((Object)responsibilitySearchResultCopy, (Object)responsibilitySearchResult);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        List roleResponsibilitys = this.getDataObjectService().findMatching(RoleResponsibilityBo.class, QueryByCriteria.Builder.forAttribute((String)"responsibilityId", (Object)responsibilitySearchResultCopy.getId()).build()).getResults();
        ArrayList<RoleBo> assignedToRoles = new ArrayList<RoleBo>();
        for (RoleResponsibilityBo roleResponsibilityImpl : roleResponsibilitys) {
            assignedToRoles.add((RoleBo)this.getDataObjectService().find(RoleBo.class, (Object)roleResponsibilityImpl.getRoleId()));
        }
        responsibilitySearchResultCopy.setAssignedToRoles(assignedToRoles);
        return responsibilitySearchResultCopy;
    }
}

