/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.config;

import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class KCBInitializer
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    private BeanFactory beanFactory;
    private Trigger messageProcessingTrigger;
    private JobDetail messageProcessingJobDetail;
    protected Scheduler scheduler;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Required
    public void setMessageProcessingTrigger(Trigger messageProcessingTrigger) {
        this.messageProcessingTrigger = messageProcessingTrigger;
    }

    @Required
    public void setMessageProcessingJobDetail(JobDetail messageProcessingJobDetail) {
        this.messageProcessingJobDetail = messageProcessingJobDetail;
    }

    public void afterPropertiesSet() throws Exception {
        GlobalKCBServiceLocator.init(this.beanFactory);
        this.beanFactory = null;
        Scheduler scheduler = this.getScheduler() == null ? KSBServiceLocator.getScheduler() : this.getScheduler();
        scheduler.addJob(this.messageProcessingJobDetail, true);
        this.addTriggerToScheduler(this.messageProcessingTrigger);
    }

    private void addTriggerToScheduler(Trigger trigger) throws SchedulerException {
        boolean triggerExists;
        boolean bl = triggerExists = this.getScheduler().getTrigger(trigger.getKey()) != null;
        if (!triggerExists) {
            try {
                this.getScheduler().scheduleJob(trigger);
            }
            catch (ObjectAlreadyExistsException ex) {
                this.getScheduler().rescheduleJob(trigger.getKey(), trigger);
            }
        } else {
            this.getScheduler().rescheduleJob(trigger.getKey(), trigger);
        }
    }

    public void destroy() throws Exception {
        GlobalKCBServiceLocator.destroy();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

