/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class RouteDocumentAction
extends ActionTakenEvent {
    private static final Logger LOG = LogManager.getLogger(RouteDocumentAction.class);

    public RouteDocumentAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        super("C", rh, principal);
    }

    public RouteDocumentAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super("C", rh, principal, annotation);
    }

    @Override
    public String getActionPerformedCode() {
        return "O";
    }

    @Override
    public String validateActionRules() {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be routed";
        }
        if (!KEWServiceLocator.getDocumentTypePermissionService().canRoute(this.getPrincipal().getPrincipalId(), this.getRouteHeader())) {
            return "User is not authorized to Route document";
        }
        return "";
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules();
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Routing document : " + this.annotation);
        }
        LOG.debug("Checking to see if the action is legal");
        String errorMessage = this.validateActionRules();
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug("Record the routing action");
        ActionTakenValue actionTaken = this.saveActionTaken();
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findPendingByDoc(this.getDocumentId());
        LOG.debug("Deactivate all pending action requests");
        for (ActionRequestValue actionRequest : actionRequests) {
            if (this.getPrincipal().getPrincipalId().equals(actionRequest.getPrincipalId()) && actionRequest.isActive()) {
                this.getActionRequestService().deactivateRequest(actionTaken, actionRequest);
                continue;
            }
            if (!"-3".equals(actionRequest.getResponsibilityId())) continue;
            this.getActionRequestService().deactivateRequest(actionTaken, actionRequest);
        }
        this.notifyActionTaken(actionTaken);
        try {
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            this.getRouteHeader().markDocumentEnroute();
            if (((ProcessDefinitionBo)this.getRouteHeader().getDocumentType().getProcesses().get(0)).getInitialRouteNode() == null) {
                this.getRouteHeader().setApprovedDate(new Timestamp(System.currentTimeMillis()));
                this.notifyStatusChange(this.getRouteHeader().getDocRouteStatus(), oldStatus);
                oldStatus = this.getRouteHeader().getDocRouteStatus();
                this.getRouteHeader().markDocumentProcessed();
                this.notifyStatusChange(this.getRouteHeader().getDocRouteStatus(), oldStatus);
                oldStatus = this.getRouteHeader().getDocRouteStatus();
                this.getRouteHeader().markDocumentFinalized();
            }
            this.getRouteHeader().setRoutedByUserWorkflowId(this.getPrincipal().getPrincipalId());
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            this.notifyStatusChange(newStatus, oldStatus);
            DocumentRouteHeaderValue persistedRouteHeader = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.getRouteHeader());
            this.setRouteHeader(persistedRouteHeader);
        }
        catch (WorkflowException ex) {
            LOG.warn((Object)ex, (Throwable)ex);
            throw new InvalidActionTakenException(ex.getMessage(), (Throwable)ex);
        }
    }
}

