/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.engine.node.DynamicNode;
import org.kuali.rice.kew.engine.node.InitialNode;
import org.kuali.rice.kew.engine.node.JoinNode;
import org.kuali.rice.kew.engine.node.RequestActivationNode;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RoleNode;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SimpleJoinNode;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.SimpleSplitNode;
import org.kuali.rice.kew.engine.node.SimpleSubProcessNode;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SubProcessNode;

public class NodeType {
    private static final String SIMPLE_NAME = "simple";
    private static final String JOIN_NAME = "join";
    private static final String SPLIT_NAME = "split";
    private static final String SUB_PROCESS_NAME = "process";
    private static final String DYNAMIC_NAME = "dynamic";
    private static final String START_NAME = "start";
    private static final String REQUEST_ACTIVATION_NAME = "requestActivation";
    private static final String REQUESTS_NAME = "requests";
    private static final String ROLE_NAME = "role";
    private static final List typeList = new ArrayList();
    private static final Comparator depthComparator = new ExtensionDepthComparator();
    public static final NodeType SIMPLE = new NodeType("simple", SimpleNode.class, null);
    public static final NodeType SPLIT = new NodeType("split", SplitNode.class, SimpleSplitNode.class);
    public static final NodeType JOIN = new NodeType("join", JoinNode.class, SimpleJoinNode.class);
    public static final NodeType SUB_PROCESS = new NodeType("process", SubProcessNode.class, SimpleSubProcessNode.class);
    public static final NodeType DYNAMIC = new NodeType("dynamic", DynamicNode.class, null);
    public static final NodeType REQUEST_ACTIVATION = new NodeType(SIMPLE, "requestActivation", RequestActivationNode.class, RequestActivationNode.class);
    public static final NodeType START = new NodeType(REQUEST_ACTIVATION, "start", InitialNode.class, InitialNode.class);
    public static final NodeType REQUESTS = new NodeType(REQUEST_ACTIVATION, "requests", RequestsNode.class, RequestsNode.class);
    public static final NodeType ROLE = new NodeType(REQUESTS, "role", RoleNode.class, RoleNode.class);
    private NodeType extensionBase;
    private String name;
    private Class baseClass;
    private Class defaultClass;
    private int extensionDepth = 0;

    private NodeType(String name, Class baseClass, Class defaultClass) {
        this(null, name, baseClass, defaultClass);
    }

    private NodeType(NodeType extensionBase, String name, Class baseClass, Class defaultClass) {
        this.extensionBase = extensionBase;
        this.name = name;
        this.baseClass = baseClass;
        this.defaultClass = defaultClass;
        while (extensionBase != null) {
            ++this.extensionDepth;
            extensionBase = extensionBase.getExtensionBase();
        }
        typeList.add(this);
        Collections.sort(typeList, depthComparator);
    }

    public NodeType getExtensionBase() {
        return this.extensionBase;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public Class getDefaultClass() {
        return this.defaultClass;
    }

    public String getName() {
        return this.name;
    }

    public int getExtensionDepth() {
        return this.extensionDepth;
    }

    public boolean isAssignableFrom(Class typeClass) {
        return this.getBaseClass().isAssignableFrom(typeClass);
    }

    public boolean isAssignableFrom(NodeType type) {
        return this.getBaseClass().isAssignableFrom(type.getBaseClass());
    }

    public boolean isInstanceOf(Object object) {
        return ClassLoaderUtils.isInstanceOf((Object)object, (Class)this.getBaseClass());
    }

    public boolean isTypeOf(Class typeClass) {
        return typeClass.isAssignableFrom(this.getBaseClass());
    }

    public boolean isTypeOf(NodeType type) {
        return type.getBaseClass().isAssignableFrom(this.getBaseClass());
    }

    public boolean isCustomNode(String className) {
        return this.getDefaultClass() == null || !this.getDefaultClass().getName().equals(className);
    }

    public boolean equals(Object object) {
        if (object instanceof NodeType) {
            return ((NodeType)object).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static NodeType fromClassName(String className) throws ResourceUnavailableException {
        Object typeObject = GlobalResourceLoader.getResourceLoader().getObject(new ObjectDefinition(className));
        if (typeObject == null) {
            throw new ResourceUnavailableException("Could not locate the node with the given class name '" + className + "'.");
        }
        for (NodeType type : typeList) {
            if (!type.isInstanceOf(typeObject)) continue;
            return type;
        }
        return null;
    }

    public static NodeType fromNode(RouteNode node) throws ResourceUnavailableException {
        return NodeType.fromClassName(node.getNodeType());
    }

    public static NodeType fromNodeInstance(RouteNodeInstance nodeInstance) throws ResourceUnavailableException {
        return NodeType.fromNode(nodeInstance.getRouteNode());
    }

    public static List<NodeType> getTypeList() {
        return typeList;
    }

    private static class ExtensionDepthComparator
    implements Comparator {
        private ExtensionDepthComparator() {
        }

        public int compare(Object object1, Object object2) {
            NodeType type1 = (NodeType)object1;
            NodeType type2 = (NodeType)object2;
            if (type1.getExtensionDepth() > type2.getExtensionDepth()) {
                return -1;
            }
            if (type1.getExtensionDepth() < type2.getExtensionDepth()) {
                return 1;
            }
            return 0;
        }
    }
}

