/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.transition;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.ProcessResult;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SubProcessNode;
import org.kuali.rice.kew.engine.node.SubProcessResult;
import org.kuali.rice.kew.engine.transition.Transition;
import org.kuali.rice.kew.engine.transition.TransitionEngine;

public class SubProcessTransitionEngine
extends TransitionEngine {
    @Override
    public RouteNodeInstance transitionTo(RouteNodeInstance nextNodeInstance, RouteContext context) throws Exception {
        String processName = nextNodeInstance.getRouteNode().getRouteNodeName();
        ProcessDefinitionBo process = context.getDocument().getDocumentType().getNamedProcess(processName);
        if (process == null) {
            throw new WorkflowException("Could not locate named sub process: " + processName);
        }
        RouteNodeInstance subProcessNodeInstance = nextNodeInstance;
        subProcessNodeInstance.setInitial(false);
        subProcessNodeInstance.setActive(false);
        nextNodeInstance = this.getRouteHelper().getNodeFactory().createRouteNodeInstance(subProcessNodeInstance.getDocumentId(), process.getInitialRouteNode());
        nextNodeInstance.setBranch(subProcessNodeInstance.getBranch());
        nextNodeInstance.setProcess(subProcessNodeInstance);
        return nextNodeInstance;
    }

    @Override
    public ProcessResult isComplete(RouteContext context) throws Exception {
        throw new UnsupportedOperationException("isComplete() should not be invoked on a SubProcess!");
    }

    @Override
    public Transition transitionFrom(RouteContext context, ProcessResult processResult) throws Exception {
        RouteNodeInstance processInstance = context.getNodeInstance().getProcess();
        processInstance.setComplete(true);
        SubProcessNode node = (SubProcessNode)this.getNode(processInstance.getRouteNode(), SubProcessNode.class);
        SubProcessResult result = node.process(context);
        ArrayList<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
        if (result.isComplete()) {
            List<RouteNode> nextNodes = processInstance.getRouteNode().getNextNodes();
            for (RouteNode nextNode : nextNodes) {
                RouteNodeInstance nextNodeInstance = this.getRouteHelper().getNodeFactory().createRouteNodeInstance(processInstance.getDocumentId(), nextNode);
                nextNodeInstance.setBranch(processInstance.getBranch());
                nextNodeInstance.setProcess(processInstance.getProcess());
                nextNodeInstances.add(nextNodeInstance);
            }
        }
        return new Transition(nextNodeInstances);
    }
}

