/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.common.delegate.DelegationTypeService;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ActionRequestDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService,
DelegationTypeService {
    private static final String NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME = "Non-Ad Hoc Approve Request Recipient";
    private static final String APPROVE_REQUEST_RECIPIENT_ROLE_NAME = "Approve Request Recipient";
    private static final String ACKNOWLEDGE_REQUEST_RECIPIENT_ROLE_NAME = "Acknowledge Request Recipient";
    private static final String FYI_REQUEST_RECIPIENT_ROLE_NAME = "FYI Request Recipient";
    private static final String COMPLETE_REQUEST_RECIPIENT_ROLE_NAME = "Complete Request Recipient";

    protected List<String> getRequiredAttributes() {
        ArrayList<String> attrs = new ArrayList<String>(super.getRequiredAttributes());
        attrs.add("documentNumber");
        return Collections.unmodifiableList(attrs);
    }

    protected boolean isCheckRequiredAttributes() {
        return true;
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null");
        }
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        if (qualification != null && !qualification.isEmpty()) {
            String principalId = qualification.get("principalId");
            if (qualification.containsKey("principalId") && this.hasDerivedRole(principalId, null, namespaceCode, roleName, qualification)) {
                members.add(RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        this.validateRequiredAttributesAgainstReceived(qualification);
        try {
            if (qualification != null && !qualification.isEmpty()) {
                List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getActionRequestsForPrincipalAtNode(qualification.get("documentNumber"), null, principalId);
                if (APPROVE_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName) || NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName)) {
                    for (ActionRequest ar : actionRequests) {
                        if (!ar.getActionRequested().getCode().equals("A") || !ar.getStatus().getCode().equals(ActionRequestStatus.ACTIVATED.getCode())) continue;
                        return APPROVE_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName) || NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName) && !ar.isAdHocRequest();
                    }
                    return false;
                }
                if (ACKNOWLEDGE_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName)) {
                    for (ActionRequest ar : actionRequests) {
                        if (!ar.getActionRequested().getCode().equals("K") || !ar.getStatus().getCode().equals(ActionRequestStatus.ACTIVATED.getCode())) continue;
                        return true;
                    }
                    return false;
                }
                if (FYI_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName)) {
                    for (ActionRequest ar : actionRequests) {
                        if (!ar.getActionRequested().getCode().equals("F") || !ar.getStatus().getCode().equals(ActionRequestStatus.ACTIVATED.getCode())) continue;
                        return true;
                    }
                    return false;
                }
                if (COMPLETE_REQUEST_RECIPIENT_ROLE_NAME.equals(roleName)) {
                    for (ActionRequest ar : actionRequests) {
                        if (!ar.getActionRequested().getCode().equals("C") || !ar.getStatus().getCode().equals(ActionRequestStatus.ACTIVATED.getCode())) continue;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        catch (RiceIllegalArgumentException e) {
            throw new RuntimeException("Unable to load route header", e);
        }
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        return true;
    }
}

