/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.web;

import java.util.ArrayList;
import java.util.List;

/**
 * A tree of boolean flags which represent the state of show/hide for the GUI.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ShowHideTree implements java.io.Serializable {

	private static final long serialVersionUID = 6048341469002946402L;

	private Boolean show = Boolean.TRUE;
    private List children = new ArrayList();
    
    public ShowHideTree() {
    }
    
    public List getChildren() {
        return children;
    }
    
    public void setChildren(List children) {
        this.children = children;
    }
        
    public ShowHideTree getChild(Integer value) {
        return getChild(value.intValue());
    }
    
    public ShowHideTree getChild(int value) {
        for (int index = children.size(); index <= value; index++) {
            children.add(new ShowHideTree());
        }
        return (ShowHideTree)children.get(value);
    }
    
    public ShowHideTree append() {
        return getChild(children.size());
    }
    
    public ShowHideTree remove(Integer index) {
        return remove(index.intValue());
    }
    
    public ShowHideTree remove(int index) {
        return (ShowHideTree)children.remove(index);
    }
        
    public Boolean getShow() {
        return show;
    }
    
    public void setShow(Boolean show) {
        this.show = show;
    }
        
}
