/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.rule.event.ui;

import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.rule.ui.AddMemberRule;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.DocumentEventBase;

public class AddMemberEvent extends DocumentEventBase {
	private KimDocumentRoleMember member;

	public AddMemberEvent(String errorPathPrefix, IdentityManagementRoleDocument document) {
        super("adding Member document " + getDocumentId(document), errorPathPrefix, document);
    }

    public AddMemberEvent(String errorPathPrefix, Document document, KimDocumentRoleMember member) {
        this(errorPathPrefix, (IdentityManagementRoleDocument) document);
        this.member = KradDataServiceLocator.getDataObjectService().copyInstance(member);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddMemberRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddMemberRule) rule).processAddMember(this);
    }

	/**
	 * @return the member
	 */
	public KimDocumentRoleMember getMember() {
		return this.member;
	}

	/**
	 * @param member the member to set
	 */
	public void setMember(KimDocumentRoleMember member) {
		this.member = member;
	}

}
