/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;

/**
 * A Node type which can be used to dynamically generate a route path for a document.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DynamicNode extends Node {

	/**
	 * Invoked when the engine first encounters this DynamicNode.  Should return a {@link DynamicResult} containing 
	 * the first {@link RouteNodeInstance} in the dynamic process.
	 */
	public DynamicResult transitioningInto(RouteContext context, RouteNodeInstance process, RouteHelper helper) throws Exception;
	
	/**
	 * Invoked everytime a node in the dynamic process completes.  Should return a {@link DynamicResult} with the 
	 * {@link RouteNodeInstance} (or instances) of the next node in the dynamic graph.  If this returns no next 
	 * node then the dynamic process will be considered completed.
	 */
	public DynamicResult transitioningOutOf(RouteContext context, RouteHelper helper) throws Exception;
	
}
