/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule.bo;

import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleDelegationBo;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

import java.util.ArrayList;
import java.util.List;

/**
 * A values finder for generating a list of Role names that can be selected for a given RuleTemplate.
 * 
 * This is dependant on the template selected on the maintenance document so it needs to use
 * GlobalVariables to get a reference to the KualiForm so it can examine the business object
 * and extract the role names from the RuleTemplate.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RoleNameValuesFinder extends KeyValuesBase {
	
	@Override
	public List<KeyValue> getKeyValues() {
		List<KeyValue> roleNames = new ArrayList<KeyValue>();
		if (KNSGlobalVariables.getKualiForm() != null && KNSGlobalVariables.getKualiForm() instanceof KualiMaintenanceForm) {
			KualiMaintenanceForm form = (KualiMaintenanceForm)KNSGlobalVariables.getKualiForm();
			MaintenanceDocument document = (MaintenanceDocument)form.getDocument();
			PersistableBusinessObject businessObject = document.getNewMaintainableObject().getBusinessObject();
			RuleBaseValues rule = null;
			if (businessObject instanceof RuleBaseValues) {
				rule = (RuleBaseValues)businessObject;
			} else if (businessObject instanceof RuleDelegationBo) {
				rule = ((RuleDelegationBo)businessObject).getDelegationRule();
			} else {
				throw new RiceRuntimeException("Cannot locate RuleBaseValues business object on maintenance document.  Business Object was " + businessObject);
			}
			RuleTemplateBo ruleTemplate = rule.getRuleTemplate();
			List<RoleName> roles = ruleTemplate.getRoles();
			for (RoleName role : roles) {
				roleNames.add(new ConcreteKeyValue(role.getName(), role.getLabel()));
			}
		}
		return roleNames;
	}

}
