/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.inquiry;

import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

/**
 * Helper class for common needs of the KIM inquiry screens. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class KimInquirableImpl extends KualiInquirableImpl {
    private static final long serialVersionUID = 1L;
    
    protected final String ID = "id";
    protected final String NAME = "name";
    protected final String NAME_TO_DISPLAY = "nameToDisplay";
    protected final String TEMPLATE_NAME = "template.name";
    protected final String NAMESPACE_CODE = "namespaceCode";
    protected final String TEMPLATE_NAMESPACE_CODE = "template.namespaceCode";
    protected final String DETAIL_OBJECTS = "detailObjects";
    protected final String ATTRIBUTE_DATA_ID = "attributeDataId";
    protected final String ASSIGNED_TO_ROLES = "assignedToRolesToDisplay";

    protected String getKimAttributeLabelFromDD(String attributeName){
        return KRADServiceLocatorWeb.getDataDictionaryService().getAttributeLabel(KimAttributes.class, attributeName);
    }
    
}
