/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.List;

/**
 * The result of the processing of a {@link SplitNode}.  Contains a List of branch names that
 * the document's route path should split to.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SplitResult extends SimpleResult {

	private List<String> branchNames = new ArrayList<String>();
	
	public SplitResult(List<String> branchNames) {
		super(true);
		this.branchNames = branchNames;
	}

	public List<String> getBranchNames() {
		return branchNames;
	}

	protected void setBranchNames(List<String> branchNames) {
		this.branchNames = branchNames;
	}
	
	
	
}
