/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.web.struts.action;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdentityManagementRoleInquiry extends IdentityManagementBaseInquiryAction {
	private static final Logger LOG = LogManager.getLogger(IdentityManagementRoleInquiry.class);

	@Override
	protected void loadKimObject(HttpServletRequest request,
			IdentityManagementDocumentFormBase form) {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm) form;
        String id = request.getParameter(KimConstants.PrimaryKeyConstants.ROLE_ID);
        String altId =  request.getParameter(KimConstants.PrimaryKeyConstants.SUB_ROLE_ID);

        String roleId = StringUtils.isNotEmpty(id) ? id : altId;
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        if (role != null) {
        	getUiDocumentService().loadRoleDoc(roleDocumentForm.getRoleDocument(), role);
        } else {
        	LOG.error("No records found for Role Inquiry: " + request.getParameterMap());
            GlobalVariables.getMessageMap().putError(KRADConstants.GLOBAL_ERRORS, RiceKeyConstants.ERROR_INQUIRY);
        }
	}

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {

        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm) form;

        ActionForward forward = super.execute(mapping, form, request, response);

        String previouslySortedColumnName = (String)GlobalVariables.getUserSession().retrieveObject(KimConstants.KimUIConstants.KIM_ROLE_INQUIRY_SORT_PREV_COL_NM);
        Boolean sortDescending = ((Boolean)GlobalVariables.getUserSession().retrieveObject(KimConstants.KimUIConstants.KIM_ROLE_INQUIRY_SORT_DESC_VALUE));

        KualiTableRenderFormMetadata memberTableMetadata =  roleDocumentForm.getMemberTableMetadata();
        memberTableMetadata.setPreviouslySortedColumnName(previouslySortedColumnName);
        String columnToSort = memberTableMetadata.getColumnToSortName();
        if  (previouslySortedColumnName != null && StringUtils.isEmpty(columnToSort)) {
            memberTableMetadata.setColumnToSortName(previouslySortedColumnName);
        }
        if (sortDescending != null && !StringUtils.isEmpty(columnToSort)) {
            memberTableMetadata.setSortDescending(sortDescending.booleanValue());
        }
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.sort(roleDocumentForm.getMemberRows(), roleDocumentForm.getRecordsPerPage());
            memberTableMetadata.jumpToPage(memberTableMetadata.getSwitchToPageNumber(), roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }

        GlobalVariables.getUserSession().addObject(KimConstants.KimUIConstants.KIM_ROLE_INQUIRY_SORT_PREV_COL_NM, memberTableMetadata.getPreviouslySortedColumnName());
        GlobalVariables.getUserSession().addObject(KimConstants.KimUIConstants.KIM_ROLE_INQUIRY_SORT_DESC_VALUE, memberTableMetadata.isSortDescending());

        return forward;
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward(RiceConstants.MAPPING_BASIC);
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm) form;
        String memberSearchValue = roleDocumentForm.getMemberSearchValue();
        if (memberSearchValue != null && !memberSearchValue.isEmpty()) {
            memberSearchValue = memberSearchValue.replaceAll("[%*]","");
            getUiDocumentService().loadRoleMembersBasedOnSearch(roleDocumentForm.getRoleDocument(), memberSearchValue);
        } else {
            clear(mapping, form, request, response);
        }
        return mapping.findForward(RiceConstants.MAPPING_BASIC);
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm) form;
        roleDocumentForm.setMemberSearchValue("");
        getUiDocumentService().clearRestrictedRoleMembersSearchResults(roleDocumentForm.getRoleDocument());

        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }
        return mapping.findForward(RiceConstants.MAPPING_BASIC);
    }
}
