/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.util;

import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kim.api.identity.Person;

public class WebFriendlyRecipient
implements Recipient {
    private static final long serialVersionUID = 2259350039081951688L;
    private String displayName;
    private String recipientId;

    public WebFriendlyRecipient(String recipientId, String displayName) {
        this.recipientId = recipientId;
        this.displayName = displayName;
    }

    public WebFriendlyRecipient(Object recipient) {
        if (recipient instanceof WebFriendlyRecipient) {
            this.recipientId = ((WebFriendlyRecipient)recipient).getRecipientId();
            this.displayName = ((WebFriendlyRecipient)recipient).getDisplayName();
        } else if (recipient instanceof Person) {
            this.recipientId = ((Person)recipient).getPrincipalId();
            this.displayName = ((Person)recipient).getLastName() + ", " + ((Person)recipient).getFirstName();
        } else if (recipient instanceof KimGroupRecipient) {
            this.recipientId = ((KimGroupRecipient)recipient).getGroupId();
            this.displayName = ((KimGroupRecipient)recipient).getGroup().getNamespaceCode() + ":" + ((KimGroupRecipient)recipient).getGroup().getName();
        } else {
            throw new IllegalArgumentException("Must pass in type Recipient or Person");
        }
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

