/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.kuali.rice.test.MethodAware;
import org.kuali.rice.test.lifecycles.PerTestDataLoaderLifecycle;
import org.kuali.rice.test.runners.RiceUnitTestClassRunner;

@RunWith(value=RiceUnitTestClassRunner.class)
public abstract class BaseRiceTestCase
implements MethodAware {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private static final Map<String, Level> changedLogLevels = new HashMap<String, Level>();
    private String name;
    private PerTestDataLoaderLifecycle perTestDataLoaderLifecycle;
    protected Method method;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.resetLogLevels();
    }

    protected void setLogLevel(String loggerName, Level newLevel) {
    }

    protected void resetLogLevels() {
    }

    @Override
    public void setTestMethod(Method testMethod) {
        this.method = testMethod;
        this.perTestDataLoaderLifecycle = new PerTestDataLoaderLifecycle(this.method);
    }

    public Method getTestMethod() {
        return this.method;
    }

    protected PerTestDataLoaderLifecycle getPerTestDataLoaderLifecycle() {
        return this.perTestDataLoaderLifecycle;
    }
}

