/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.lifecycles;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.kew.batch.KEWXmlDataLoader;

public class KEWXmlDataLoaderLifecycle
extends BaseLifecycle {
    private static final Logger LOG = LogManager.getLogger(KEWXmlDataLoaderLifecycle.class);
    private String filename;

    public KEWXmlDataLoaderLifecycle(String resource) {
        this.filename = resource;
    }

    public void start() throws Exception {
        String useKewXmlDataLoaderLifecycle = ConfigContext.getCurrentContextConfig().getProperty("use.kewXmlmlDataLoaderLifecycle");
        if (useKewXmlDataLoaderLifecycle != null && !Boolean.valueOf(useKewXmlDataLoaderLifecycle).booleanValue()) {
            LOG.debug("Skipping KEWXmlDataLoaderLifecycle due to property: use.kewXmlmlDataLoaderLifecycle=" + useKewXmlDataLoaderLifecycle);
            return;
        }
        LOG.info("################################");
        LOG.info("#");
        LOG.info("#  Begin Loading file '" + this.filename + "'");
        LOG.info("#");
        LOG.info("################################");
        this.loadData();
        super.start();
    }

    protected void loadData() throws Exception {
        KEWXmlDataLoader.loadXmlResource((String)this.filename);
    }
}

