/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.MethodUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.rules.RuleMemberValidator;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.kuali.rice.core.api.util.ShadowingInstrumentableClassLoader;
import org.kuali.rice.test.MethodAware;
import org.kuali.rice.test.runners.BootstrapTest;

public class LoadTimeWeavableTestRunner
extends Runner
implements Filterable,
Sortable {
    private static final String[] JUNIT_CLASSLOADER_EXCLUDES = new String[]{"org.junit.", "junit.framework."};
    private final TestClass originalTestClass;
    private TestClass fTestClass;
    private Method currentMethod;
    private static ClassLoader customLoader;
    private Sorter fSorter = Sorter.NULL;
    private List<FrameworkMethod> originalFilteredChildren = null;
    private List<FrameworkMethod> filteredChildren = null;
    private static final ThreadLocal<Boolean> runningBootstrapTest;
    private RunnerScheduler fScheduler = new RunnerScheduler(){

        public void schedule(Runnable childStatement) {
            childStatement.run();
        }

        public void finished() {
        }
    };

    public LoadTimeWeavableTestRunner(Class<?> testClass) throws InitializationError {
        this.originalTestClass = new TestClass(testClass);
        if (customLoader == null) {
            customLoader = new ShadowingInstrumentableClassLoader(testClass.getClassLoader(), JUNIT_CLASSLOADER_EXCLUDES);
        }
        this.validate();
    }

    private TestClass getCustomTestClass(Class<?> originalTestClass, ClassLoader customLoader) {
        try {
            Class<?> newTestClass = customLoader.loadClass(originalTestClass.getName());
            if (newTestClass == originalTestClass) {
                throw new IllegalStateException(newTestClass.getName() + " loaded from custom class loader should have been a different instance but was the same!");
            }
            return new TestClass(newTestClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load test class from custom classloader: " + originalTestClass.getName(), e);
        }
    }

    protected ClassLoader getCustomClassLoader() {
        return customLoader;
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getOriginalTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoidNoArg(isStatic, errors);
        }
    }

    private void validateClassRules(List<Throwable> errors) {
        RuleMemberValidator.CLASS_RULE_VALIDATOR.validate(this.getOriginalTestClass(), errors);
        RuleMemberValidator.CLASS_RULE_METHOD_VALIDATOR.validate(this.getOriginalTestClass(), errors);
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        statement = this.withBeforeClasses(statement);
        statement = this.withAfterClasses(statement);
        statement = this.withClassRules(statement);
        return statement;
    }

    protected Statement withBeforeClasses(Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, null);
    }

    private Statement withClassRules(Statement statement) {
        List<TestRule> classRules = this.classRules();
        return classRules.isEmpty() ? statement : new RunRules(statement, classRules, this.getDescription());
    }

    protected List<TestRule> classRules() {
        List result = this.getTestClass().getAnnotatedMethodValues(null, ClassRule.class, TestRule.class);
        result.addAll(this.getTestClass().getAnnotatedFieldValues(null, ClassRule.class, TestRule.class));
        return result;
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                LoadTimeWeavableTestRunner.this.runChildren(notifier);
            }
        };
    }

    private void runChildren(final RunNotifier notifier) {
        for (final FrameworkMethod each : this.getFilteredChildren()) {
            this.fScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    LoadTimeWeavableTestRunner.this.runChild(each, notifier);
                }
            });
        }
        this.fScheduler.finished();
    }

    protected String getName() {
        return this.getOriginalTestClass().getName();
    }

    public final TestClass getTestClass() {
        if (this.fTestClass == null) {
            throw new IllegalStateException("Attempted to access test class but it has not yet been initialized!");
        }
        return this.fTestClass;
    }

    public final TestClass getOriginalTestClass() {
        return this.originalTestClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runLeaf(Statement statement, Description description, RunNotifier notifier) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    protected Annotation[] getRunnerAnnotations() {
        return this.getOriginalTestClass().getAnnotations();
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getRunnerAnnotations());
        for (FrameworkMethod child : this.getOriginalFilteredChildren()) {
            description.addChild(this.describeOriginalChild(child));
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        block7: {
            ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(customLoader);
            try {
                if (!this.runBootstrapTest(notifier, this.getOriginalTestClass())) break block7;
                this.fTestClass = this.getCustomTestClass(this.getOriginalTestClass().getJavaClass(), customLoader);
                EachTestNotifier testNotifier = new EachTestNotifier(notifier, this.getDescription());
                try {
                    Statement statement = this.classBlock(notifier);
                    statement.evaluate();
                }
                catch (AssumptionViolatedException e) {
                    testNotifier.fireTestIgnored();
                }
                catch (StoppedByUserException e) {
                    throw e;
                }
                catch (Throwable e) {
                    testNotifier.addFailure(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
            }
        }
    }

    protected boolean runBootstrapTest(RunNotifier notifier, TestClass testClass) {
        if (!runningBootstrapTest.get().booleanValue()) {
            runningBootstrapTest.set(Boolean.TRUE);
            try {
                BootstrapTest bootstrapTest = this.getBootstrapTestAnnotation(testClass.getJavaClass());
                if (bootstrapTest != null) {
                    Result result = JUnitCore.runClasses((Class[])new Class[]{bootstrapTest.value()});
                    List failures = result.getFailures();
                    for (Failure failure : failures) {
                        notifier.fireTestFailure(failure);
                    }
                    boolean bl = result.getFailureCount() == 0;
                    return bl;
                }
                throw new IllegalStateException("LoadTimeWeavableTestRunner, must be coupled with an @BootstrapTest annotation to define the bootstrap test to execute.");
            }
            finally {
                runningBootstrapTest.set(Boolean.FALSE);
            }
        }
        return true;
    }

    private BootstrapTest getBootstrapTestAnnotation(Class<?> testClass) {
        BootstrapTest bootstrapTest = testClass.getAnnotation(BootstrapTest.class);
        if (bootstrapTest != null) {
            return bootstrapTest;
        }
        if (testClass.getSuperclass() != null) {
            return this.getBootstrapTestAnnotation(testClass.getSuperclass());
        }
        return null;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<FrameworkMethod> iter = this.getOriginalFilteredChildren().iterator();
        while (iter.hasNext()) {
            FrameworkMethod each = iter.next();
            if (this.shouldRun(filter, each)) {
                try {
                    filter.apply((Object)each);
                }
                catch (NoTestsRemainException e) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
        if (this.getOriginalFilteredChildren().isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(Sorter sorter) {
        this.fSorter = sorter;
        for (FrameworkMethod each : this.getOriginalFilteredChildren()) {
            this.sortChild(each);
        }
        Collections.sort(this.getOriginalFilteredChildren(), this.comparator());
    }

    private void validate() throws InitializationError {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.collectInitializationErrors(errors);
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private List<FrameworkMethod> getOriginalFilteredChildren() {
        if (this.originalFilteredChildren == null) {
            this.originalFilteredChildren = new ArrayList<FrameworkMethod>(this.getOriginalChildren());
        }
        return this.originalFilteredChildren;
    }

    private List<FrameworkMethod> getFilteredChildren() {
        if (this.getOriginalFilteredChildren() == null) {
            throw new IllegalStateException("Attempted to get filtered children before original filtered children were initialized.");
        }
        if (this.filteredChildren == null) {
            this.filteredChildren = new ArrayList<FrameworkMethod>();
            List<FrameworkMethod> testMethods = this.computeTestMethods();
            for (FrameworkMethod originalMethod : this.getOriginalFilteredChildren()) {
                for (FrameworkMethod testMethod : testMethods) {
                    if (!originalMethod.isShadowedBy(testMethod)) continue;
                    this.filteredChildren.add(testMethod);
                }
            }
        }
        return this.filteredChildren;
    }

    private void sortChild(FrameworkMethod child) {
        this.fSorter.apply((Object)child);
    }

    private boolean shouldRun(Filter filter, FrameworkMethod each) {
        return filter.shouldRun(this.describeOriginalChild(each));
    }

    private Comparator<? super FrameworkMethod> comparator() {
        return new Comparator<FrameworkMethod>(){

            @Override
            public int compare(FrameworkMethod o1, FrameworkMethod o2) {
                return LoadTimeWeavableTestRunner.this.fSorter.compare(LoadTimeWeavableTestRunner.this.describeChild(o1), LoadTimeWeavableTestRunner.this.describeChild(o2));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.currentMethod = method.getMethod();
        try {
            Description description = this.describeChild(method);
            if (method.getAnnotation(Ignore.class) != null) {
                notifier.fireTestIgnored(description);
            } else {
                this.runLeaf(this.methodBlock(method), description, notifier);
            }
        }
        finally {
            this.currentMethod = null;
        }
    }

    protected Description describeChild(FrameworkMethod method) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
    }

    protected Description describeOriginalChild(FrameworkMethod method) {
        return Description.createTestDescription((Class)this.getOriginalTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])method.getAnnotations());
    }

    protected List<FrameworkMethod> getChildren() {
        return this.computeTestMethods();
    }

    protected List<FrameworkMethod> getOriginalChildren() {
        return this.computeOriginalTestMethods();
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestClass().getAnnotatedMethods(Test.class);
    }

    protected List<FrameworkMethod> computeOriginalTestMethods() {
        return this.getOriginalTestClass().getAnnotatedMethods(Test.class);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
        this.validatePublicVoidNoArgMethods(AfterClass.class, true, errors);
        this.validateClassRules(errors);
        this.validateNoNonStaticInnerClass(errors);
        this.validateConstructor(errors);
        this.validateInstanceMethods(errors);
        this.validateFields(errors);
        this.validateMethods(errors);
    }

    protected void validateNoNonStaticInnerClass(List<Throwable> errors) {
        if (this.getOriginalTestClass().isANonStaticInnerClass()) {
            String gripe = "The inner class " + this.getOriginalTestClass().getName() + " is not static.";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
        this.validateZeroArgConstructor(errors);
    }

    protected void validateOnlyOneConstructor(List<Throwable> errors) {
        if (!this.hasOneConstructor()) {
            String gripe = "Test class should have exactly one public constructor";
            errors.add(new Exception(gripe));
        }
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
        if (!this.getOriginalTestClass().isANonStaticInnerClass() && this.hasOneConstructor() && this.getOriginalTestClass().getOnlyConstructor().getParameterTypes().length != 0) {
            String gripe = "Test class should have exactly one public zero-argument constructor";
            errors.add(new Exception(gripe));
        }
    }

    private boolean hasOneConstructor() {
        return this.getOriginalTestClass().getJavaClass().getConstructors().length == 1;
    }

    @Deprecated
    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
        if (this.computeOriginalTestMethods().size() == 0) {
            errors.add(new Exception("No runnable methods"));
        }
    }

    protected void validateFields(List<Throwable> errors) {
        RuleMemberValidator.RULE_VALIDATOR.validate(this.getOriginalTestClass(), errors);
    }

    private void validateMethods(List<Throwable> errors) {
        RuleMemberValidator.RULE_METHOD_VALIDATOR.validate(this.getOriginalTestClass(), errors);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
    }

    protected Object createTest() throws Exception {
        Object test = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        this.setTestName(test, this.currentMethod);
        this.setTestMethod(test, this.currentMethod);
        return test;
    }

    protected void setTestMethod(Object test, Method method) throws Exception {
        Class<?> methodAwareClass = Class.forName(MethodAware.class.getName(), true, this.getCustomClassLoader());
        if (methodAwareClass.isInstance(test)) {
            Method setTestMethod = methodAwareClass.getMethod("setTestMethod", Method.class);
            setTestMethod.invoke(test, method);
        }
    }

    protected void setTestName(Object test, Method testMethod) throws Exception {
        String name = testMethod == null ? "" : testMethod.getName();
        Method setNameMethod = MethodUtils.getAccessibleMethod(test.getClass(), (String)"setName", (Class[])new Class[]{String.class});
        if (setNameMethod != null) {
            setNameMethod.invoke(test, name);
        }
    }

    protected String testName(FrameworkMethod method) {
        return method.getName();
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Object test;
        try {
            test = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return LoadTimeWeavableTestRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable e) {
            return new Fail(e);
        }
        Statement statement = this.methodInvoker(method, test);
        statement = this.possiblyExpectingExceptions(method, test, statement);
        statement = this.withPotentialTimeout(method, test, statement);
        statement = this.withBefores(method, test, statement);
        statement = this.withAfters(method, test, statement);
        statement = this.withRules(method, test, statement);
        return statement;
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InvokeMethod(method, test);
    }

    @Deprecated
    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        Test annotation = (Test)method.getAnnotation(Test.class);
        return this.expectsException(annotation) ? new ExpectException(next, this.getExpectedException(annotation)) : next;
    }

    @Deprecated
    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        long timeout = this.getTimeout((Test)method.getAnnotation(Test.class));
        return timeout > 0L ? new FailOnTimeout(next, timeout) : next;
    }

    @Deprecated
    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    @Deprecated
    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        List<TestRule> testRules = this.getTestRules(target);
        Statement result = statement;
        result = this.withMethodRules(method, testRules, target, result);
        result = this.withTestRules(method, testRules, result);
        return result;
    }

    private Statement withMethodRules(FrameworkMethod method, List<TestRule> testRules, Object target, Statement result) {
        for (MethodRule each : this.getMethodRules(target)) {
            if (testRules.contains(each)) continue;
            result = each.apply(result, method, target);
        }
        return result;
    }

    private List<MethodRule> getMethodRules(Object target) {
        return this.rules(target);
    }

    protected List<MethodRule> rules(Object target) {
        return this.getTestClass().getAnnotatedFieldValues(target, Rule.class, MethodRule.class);
    }

    private Statement withTestRules(FrameworkMethod method, List<TestRule> testRules, Statement statement) {
        return testRules.isEmpty() ? statement : new RunRules(statement, testRules, this.describeChild(method));
    }

    protected List<TestRule> getTestRules(Object target) {
        List result = this.getTestClass().getAnnotatedMethodValues(target, Rule.class, TestRule.class);
        result.addAll(this.getTestClass().getAnnotatedFieldValues(target, Rule.class, TestRule.class));
        return result;
    }

    private Class<? extends Throwable> getExpectedException(Test annotation) {
        if (annotation == null || annotation.expected() == Test.None.class) {
            return null;
        }
        return annotation.expected();
    }

    private boolean expectsException(Test annotation) {
        return this.getExpectedException(annotation) != null;
    }

    private long getTimeout(Test annotation) {
        if (annotation == null) {
            return 0L;
        }
        return annotation.timeout();
    }

    static {
        runningBootstrapTest = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

