/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.bo.MessageDeliveryStatus;
import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.kcb.service.MessageDeliveryService;
import org.kuali.rice.kcb.service.MessageService;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.kcb.test.KCBTestData;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.dao.DataAccessException;

public class MessageDeliveryServiceTest
extends KCBTestCase {
    private MessageService messageService;
    private MessageDeliveryService messageDeliveryService;
    private Message MESSAGE;
    private MessageDelivery MESSAGE_DELIV;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.messageService = GlobalKCBServiceLocator.getInstance().getKcbMessageService();
        this.messageDeliveryService = GlobalKCBServiceLocator.getInstance().getMessageDeliveryService();
        this.MESSAGE = KCBTestData.getMessage1();
        this.MESSAGE = this.messageService.saveMessage(this.MESSAGE);
        this.MESSAGE_DELIV = KCBTestData.getMessageDelivery1();
        this.MESSAGE_DELIV.setMessage(this.MESSAGE);
        this.MESSAGE_DELIV = this.messageDeliveryService.saveMessageDelivery(this.MESSAGE_DELIV);
    }

    @Test
    public void testCreate() {
        MessageDelivery md = new MessageDelivery();
        md.setDelivererTypeName("pigeon");
        md.setMessage(this.MESSAGE);
        md = this.messageDeliveryService.saveMessageDelivery(md);
        Assert.assertNotNull((Object)md.getId());
        Collection ms = this.messageDeliveryService.getAllMessageDeliveries();
        Assert.assertNotNull((Object)ms);
        Assert.assertEquals((long)2L, (long)ms.size());
        MessageDelivery md2 = this.messageDeliveryService.getMessageDelivery(md.getId());
        Assert.assertNotNull((Object)md2);
        this.assertEqualsMD(md, md2);
    }

    @Test
    public void testDelete() {
        this.messageDeliveryService.deleteMessageDelivery(this.MESSAGE_DELIV);
        Collection ms = this.messageDeliveryService.getAllMessageDeliveries();
        Assert.assertNotNull((Object)ms);
        Assert.assertEquals((long)0L, (long)ms.size());
        Assert.assertNull((Object)this.messageDeliveryService.getMessageDelivery(this.MESSAGE_DELIV.getId()));
    }

    @Test(expected=DataAccessException.class)
    public void testDuplicateCreate() {
        MessageDelivery md = new MessageDelivery();
        md.setId(KCBTestData.FAKE_ID);
        md.setDelivererSystemId(this.MESSAGE_DELIV.getDelivererSystemId());
        md.setDelivererTypeName(this.MESSAGE_DELIV.getDelivererTypeName());
        md.setDeliveryStatus(this.MESSAGE_DELIV.getDeliveryStatus());
        md.setLockVerNbr(this.MESSAGE_DELIV.getLockVerNbr());
        md.setMessage(this.MESSAGE);
        KRADServiceLocator.getDataObjectService().save((Object)md, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidCreate() {
        MessageDelivery m = new MessageDelivery();
        this.messageDeliveryService.saveMessageDelivery(m);
        KRADServiceLocator.getDataObjectService().save((Object)m, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test
    public void testInvalidRead() {
        MessageDelivery m = this.messageDeliveryService.getMessageDelivery(Long.valueOf(-1L));
        Assert.assertNull((Object)m);
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidUpdate() {
        MessageDelivery m = this.messageDeliveryService.getMessageDelivery(this.MESSAGE_DELIV.getId());
        m.setDelivererTypeName(null);
        m.setDelivererSystemId(null);
        KRADServiceLocator.getDataObjectService().save((Object)m, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test
    public void testReadById() {
        MessageDelivery m = this.messageDeliveryService.getMessageDelivery(this.MESSAGE_DELIV.getId());
        this.assertEqualsMD(this.MESSAGE_DELIV, m);
    }

    @Test
    public void testUpdate() {
        MessageDelivery m = this.messageDeliveryService.getMessageDelivery(this.MESSAGE_DELIV.getId());
        m.setDelivererTypeName("eagle");
        m.setDeliveryStatus(MessageDeliveryStatus.UNDELIVERED);
        m.setDelivererSystemId("1234");
        this.messageDeliveryService.saveMessageDelivery(m);
        MessageDelivery m2 = this.messageDeliveryService.getMessageDelivery(m.getId());
        Assert.assertNotNull((Object)m2);
        this.assertEqualsMD(m, m2);
    }

    private void assertEqualsMD(MessageDelivery expected, MessageDelivery actual) {
        Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assert.assertEquals((Object)expected.getDelivererSystemId(), (Object)actual.getDelivererSystemId());
        Assert.assertEquals((Object)expected.getDelivererTypeName(), (Object)actual.getDelivererTypeName());
        Assert.assertEquals((Object)expected.getDeliveryStatus(), (Object)actual.getDeliveryStatus());
        Assert.assertEquals((Object)expected.getMessage().getId(), (Object)actual.getMessage().getId());
    }
}

