/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kcb.api.message.MessageDTO;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.bo.MessageDeliveryStatus;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.impl.JobDetailImpl;
import org.quartz.listeners.JobListenerSupport;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class MessagingServiceTest
extends KCBTestCase {
    private CountDownLatch signal = new CountDownLatch(1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.services.getRecipientPreferenceService().saveRecipientDelivererConfig("testuser5", "mock", new String[]{"Test Channel #1"});
        this.services.getRecipientPreferenceService().saveRecipientDelivererConfig("testuser5", "sms", new String[]{"Test Channel #1"});
        this.services.getRecipientPreferenceService().saveRecipientDelivererConfig("testuser5", "broken", new String[]{"Test Channel #1"});
        this.services.getRecipientPreferenceService().saveRecipientDelivererConfig("testuser5", "bogus", new String[]{"Test Channel #1"});
        Assert.assertEquals((long)4L, (long)this.services.getRecipientPreferenceService().getDeliverersForRecipientAndChannel("testuser5", "Test Channel #1").size());
    }

    protected long deliver() throws Exception {
        MessageDTO message = new MessageDTO();
        message.setContent("test content 1");
        message.setChannel("Test Channel #1");
        message.setContentType("test content type 1");
        message.setDeliveryType("test delivery type 1");
        message.setRecipient("testuser5");
        message.setTitle("test title 1");
        message.setOriginId("origin id");
        this.registerJobListener();
        long id = this.services.getMessagingService().deliver(message);
        this.waitForNextJobCompletion();
        Collection deliveries = this.services.getMessageDeliveryService().getAllMessageDeliveries();
        Assert.assertNotNull((Object)deliveries);
        int delivCount = this.services.getRecipientPreferenceService().getDeliverersForRecipientAndChannel("testuser5", "Test Channel #1").size();
        Assert.assertEquals((long)delivCount, (long)deliveries.size());
        Assert.assertTrue((deliveries.size() > 0 ? 1 : 0) != 0);
        int failed = 0;
        for (MessageDelivery delivery : deliveries) {
            if ("broken".equals(delivery.getDelivererTypeName()) || "bogus".equals(delivery.getDelivererTypeName())) {
                Assert.assertEquals((Object)MessageDeliveryStatus.UNDELIVERED.name(), (Object)delivery.getDeliveryStatus());
                Assert.assertEquals((long)1L, (long)delivery.getProcessCount().intValue());
                ++failed;
                continue;
            }
            Assert.assertEquals((Object)MessageDeliveryStatus.DELIVERED.name(), (Object)delivery.getDeliveryStatus());
        }
        Assert.assertEquals((long)2L, (long)failed);
        this.waitForNextJobCompletion();
        failed = 0;
        deliveries = this.services.getMessageDeliveryService().getAllMessageDeliveries();
        for (MessageDelivery delivery : deliveries) {
            if ("broken".equals(delivery.getDelivererTypeName()) || "bogus".equals(delivery.getDelivererTypeName())) {
                Assert.assertEquals((Object)MessageDeliveryStatus.UNDELIVERED.name(), (Object)delivery.getDeliveryStatus());
                Assert.assertEquals((long)2L, (long)delivery.getProcessCount().intValue());
                ++failed;
                continue;
            }
            Assert.assertEquals((Object)MessageDeliveryStatus.DELIVERED.name(), (Object)delivery.getDeliveryStatus());
        }
        Assert.assertEquals((long)2L, (long)failed);
        this.waitForNextJobCompletion();
        failed = 0;
        deliveries = this.services.getMessageDeliveryService().getAllMessageDeliveries();
        for (MessageDelivery delivery : deliveries) {
            if ("broken".equals(delivery.getDelivererTypeName()) || "bogus".equals(delivery.getDelivererTypeName())) {
                Assert.assertEquals((Object)MessageDeliveryStatus.UNDELIVERED.name(), (Object)delivery.getDeliveryStatus());
                Assert.assertEquals((long)3L, (long)delivery.getProcessCount().intValue());
                ++failed;
                continue;
            }
            Assert.assertEquals((Object)MessageDeliveryStatus.DELIVERED.name(), (Object)delivery.getDeliveryStatus());
        }
        Assert.assertEquals((long)2L, (long)failed);
        this.waitForNextJobCompletion();
        failed = 0;
        deliveries = this.services.getMessageDeliveryService().getAllMessageDeliveries();
        for (MessageDelivery delivery : deliveries) {
            if ("broken".equals(delivery.getDelivererTypeName()) || "bogus".equals(delivery.getDelivererTypeName())) {
                Assert.assertEquals((Object)MessageDeliveryStatus.UNDELIVERED.name(), (Object)delivery.getDeliveryStatus());
                Assert.assertEquals((long)3L, (long)delivery.getProcessCount().intValue());
                ++failed;
                continue;
            }
            Assert.assertEquals((Object)MessageDeliveryStatus.DELIVERED.name(), (Object)delivery.getDeliveryStatus());
        }
        Assert.assertEquals((long)2L, (long)failed);
        return id;
    }

    @Test
    public void testDeliver() throws Exception {
        Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive());
        this.deliver();
    }

    @Test
    public void testDismiss() throws Exception {
        Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive());
        long id = this.deliver();
        this.registerJobListener();
        this.services.getMessagingService().remove(id, "a user", "a cause");
        this.waitForNextJobCompletion();
        Collection deliveries = this.services.getMessageDeliveryService().getAllMessageDeliveries();
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)2L, (long)deliveries.size());
        for (MessageDelivery d : deliveries) {
            Assert.assertTrue(("broken".equals(d.getDelivererTypeName()) || "bogus".equals(d.getDelivererTypeName()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDismissByOriginId() throws Exception {
        Assert.assertFalse((boolean)TransactionSynchronizationManager.isActualTransactionActive());
        long id = this.deliver();
        this.registerJobListener();
        this.services.getMessagingService().removeByOriginId("origin id", "a user", "a cause");
        this.waitForNextJobCompletion();
        Collection deliveries = this.services.getMessageDeliveryService().getAllMessageDeliveries();
        Assert.assertNotNull((Object)deliveries);
        Assert.assertEquals((long)2L, (long)deliveries.size());
        Assert.assertEquals((long)2L, (long)deliveries.size());
        for (MessageDelivery d : deliveries) {
            Assert.assertTrue(("broken".equals(d.getDelivererTypeName()) || "bogus".equals(d.getDelivererTypeName()) ? 1 : 0) != 0);
        }
    }

    protected void registerJobListener() throws SchedulerException {
        KSBServiceLocator.getScheduler().getListenerManager().addJobListener((JobListener)new JobListenerSupport(){

            public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
                MessagingServiceTest.this.log.info("Job was executed: " + context);
                if ("MessageProcessingJobDetail".equals(((JobDetailImpl)context.getJobDetail()).getName())) {
                    MessagingServiceTest.this.signal.countDown();
                }
            }

            public String getName() {
                return System.currentTimeMillis() + RandomStringUtils.randomAlphanumeric((int)10);
            }
        });
    }

    protected void waitForNextJobCompletion() throws InterruptedException {
        this.log.info("Waiting for job to complete...");
        this.signal.await(100L, TimeUnit.SECONDS);
        this.signal = new CountDownLatch(1);
        this.log.info("Job completed...");
    }
}

