/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class MessageDelivererRegistryServiceTest
extends KCBTestCase {
    @Test
    public void testGetAllDeliverTypes() {
        Collection deliverers = this.services.getMessageDelivererRegistryService().getAllDeliverers();
        Assert.assertEquals((long)4L, (long)deliverers.size());
        for (MessageDeliverer deliverer : deliverers) {
            Assert.assertTrue((deliverer.getName() != null ? 1 : 0) != 0);
            Assert.assertTrue((deliverer.getName().length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetDeliverer_valid() {
        MessageDelivery mockValid = new MessageDelivery();
        mockValid.setDelivererTypeName("Email");
        MessageDeliverer deliverer = this.services.getMessageDelivererRegistryService().getDeliverer(mockValid);
        if (deliverer == null) {
            throw new RuntimeException("Message deliverer could not be obtained");
        }
        Assert.assertEquals((Object)"Email", (Object)deliverer.getName());
    }

    @Test
    public void testGetDeliverer_nonExistent() {
        MessageDelivery mockInvalid = new MessageDelivery();
        mockInvalid.setDelivererTypeName("BOGUS_DELIVERER");
        boolean caughtException = false;
        MessageDeliverer deliverer = this.services.getMessageDelivererRegistryService().getDeliverer(mockInvalid);
        Assert.assertNull((Object)deliverer);
    }

    @Test
    public void testGetDelivererByName_valid() {
        MessageDeliverer deliverer = this.services.getMessageDelivererRegistryService().getDelivererByName("Email");
        Assert.assertEquals((Object)"Email", (Object)deliverer.getName());
    }

    @Test
    public void testGetDelivererByName_nonExistent() {
        boolean caughtException = false;
        MessageDeliverer deliverer = this.services.getMessageDelivererRegistryService().getDelivererByName("BOGUS_DELIVERER");
        Assert.assertNull((Object)deliverer);
    }
}

