/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class DocumentSearchSecurityTest
extends KEWTestCase {
    private static final String WORKFLOW_ADMIN_USER_NETWORK_ID = "bmcgough";
    private static final String APPROVER_USER_NETWORK_ID = "user2";
    private static final String STANDARD_USER_NETWORK_ID = "user1";
    DocumentSearchService docSearchService;

    @Override
    protected void setUpAfterDataLoad() throws Exception {
        this.docSearchService = (DocumentSearchService)KEWServiceLocator.getService((String)"enDocumentSearchService");
    }

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("SearchSecurityConfig.xml");
    }

    @Test
    public void testDocSearchSecurityPermissionDocType() throws Exception {
        String documentTypeName = "SecurityDoc_PermissionOnly";
        String userNetworkId = "arh14";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("testDocSearch_PermissionSecurity");
        workflowDocument.route("routing this document.");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("edna");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((long)0L, (long)results.getNumberOfSecurityFilteredResults());
        Assert.assertEquals((String)"Search returned invalid number of documents", (long)1L, (long)results.getSearchResults().size());
    }

    @Test
    public void testDocSearchBadPermission() throws Exception {
        String documentTypeName = "SecurityDoc_InvalidPermissionOnly";
        String userNetworkId = "arh14";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("testDocSearch_PermissionSecurity");
        workflowDocument.route("routing this document.");
        Person user = KimApiServiceLocator.getPersonService().getPersonByPrincipalName("edna");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        DocumentSearchResults results = this.docSearchService.lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)"Search returned invalid number of documents", (long)0L, (long)results.getSearchResults().size());
    }

    @Test
    public void testFilteringInitiator() throws Exception {
        String documentType = "SecurityDoc_InitiatorOnly";
        String initiator = this.getPrincipalId(STANDARD_USER_NETWORK_ID);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)initiator, (String)documentType);
        document.route("");
        Assert.assertFalse((String)"Document should not be in init status after routing", (boolean)document.isInitiated());
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        DocumentSearchResults results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(initiator, criteria.build());
        Assert.assertEquals((String)"Should retrive one record from search", (long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"No rows should have been filtered due to security", (long)0L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId("user3"), criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(WORKFLOW_ADMIN_USER_NETWORK_ID), criteria.build());
        Assert.assertEquals((String)"Should retrive one record from search", (long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"No rows should have been filtered due to security", (long)0L, (long)results.getNumberOfSecurityFilteredResults());
    }

    @Test
    public void testFiltering_Workgroup() throws Exception {
        String documentType = "SecurityDoc_WorkgroupOnly";
        String initiator = this.getPrincipalId(STANDARD_USER_NETWORK_ID);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)initiator, (String)documentType);
        document.route("");
        Assert.assertFalse((String)"Document should not be in init status after routing", (boolean)document.isInitiated());
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        DocumentSearchResults results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(initiator, criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
        String workgroupName = "Test_Security_Group";
        Group group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName("KR-WKFLW", workgroupName);
        Assert.assertNotNull((String)("Workgroup '" + workgroupName + "' should be valid"), (Object)group);
        for (String workgroupUserId : KimApiServiceLocator.getGroupService().getMemberPrincipalIds(group.getId())) {
            Person workgroupUser = KimApiServiceLocator.getPersonService().getPerson(workgroupUserId);
            criteria = DocumentSearchCriteria.Builder.create();
            criteria.setDocumentId(document.getDocumentId());
            results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(workgroupUser.getPrincipalId(), criteria.build());
            Assert.assertEquals((String)("Should retrive one record from search for user " + workgroupUser), (long)1L, (long)results.getSearchResults().size());
            Assert.assertEquals((String)("No rows should have been filtered due to security for user " + workgroupUser), (long)0L, (long)results.getNumberOfSecurityFilteredResults());
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId("user3"), criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(WORKFLOW_ADMIN_USER_NETWORK_ID), criteria.build());
        Assert.assertEquals((String)"Should retrive one record from search", (long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"No rows should have been filtered due to security", (long)0L, (long)results.getNumberOfSecurityFilteredResults());
    }

    @Test
    public void testFiltering_SearchAttribute() throws Exception {
        String searchAttributeName = "UserEmployeeId";
        String searchAttributeFieldName = "employeeId";
        String documentTypeName = "SecurityDoc_SearchAttributeOnly";
        String initiatorNetworkId = STANDARD_USER_NETWORK_ID;
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalId(initiatorNetworkId), (String)documentTypeName);
        WorkflowAttributeDefinition.Builder definition = WorkflowAttributeDefinition.Builder.create((String)searchAttributeName);
        definition.addPropertyDefinition(searchAttributeFieldName, "user3");
        document.addSearchableDefinition(definition.build());
        document.route("");
        Assert.assertFalse((String)"Document should not be in init status after routing", (boolean)document.isInitiated());
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        DocumentSearchResults results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(initiatorNetworkId), criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId("user3"), criteria.build());
        Assert.assertEquals((String)"Should retrive one record from search", (long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"No rows should have been filtered due to security", (long)0L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(APPROVER_USER_NETWORK_ID), criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(WORKFLOW_ADMIN_USER_NETWORK_ID), criteria.build());
        Assert.assertEquals((String)"Should retrive one record from search", (long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"No rows should have been filtered due to security", (long)0L, (long)results.getNumberOfSecurityFilteredResults());
        RouteContext.clearCurrentRouteContext();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalId(APPROVER_USER_NETWORK_ID), (String)document.getDocumentId());
        document.clearSearchableContent();
        definition = WorkflowAttributeDefinition.Builder.create((String)searchAttributeName);
        definition.addPropertyDefinition(searchAttributeFieldName, APPROVER_USER_NETWORK_ID);
        document.addSearchableDefinition(definition.build());
        document.saveDocumentData();
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(APPROVER_USER_NETWORK_ID), criteria.build());
        Assert.assertEquals((String)"Should retrive one record from search", (long)1L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"No rows should have been filtered due to security", (long)0L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId("user3"), criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentId(document.getDocumentId());
        results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(this.getPrincipalId(initiatorNetworkId), criteria.build());
        Assert.assertEquals((String)"Should retrive no records from search", (long)0L, (long)results.getSearchResults().size());
        Assert.assertEquals((String)"One row should have been filtered due to security", (long)1L, (long)results.getNumberOfSecurityFilteredResults());
    }

    private String getPrincipalId(String principalName) {
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName).getPrincipalId();
    }
}

