/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.postprocessor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class PostProcessorTest
extends KEWTestCase {
    private static final String APPLICATION_CONTENT = "<some><application>content</application></some>";
    private static final String DOC_TITLE = "The Doc Title";
    private static boolean shouldReturnDocumentIdsToLock = false;
    private static String documentAId = null;
    private static String documentBId = null;
    private static UpdateDocumentThread updateDocumentThread = null;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("PostProcessorConfig.xml");
    }

    @Test
    public void testModifyDocumentInPostProcessor() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"testModifyDocumentInPostProcessor");
        document.saveDocument("");
        Assert.assertEquals((String)"application content should be empty initially", (Object)"", (Object)document.getApplicationContent());
        Assert.assertTrue((String)"Doc title should be empty initially", (boolean)StringUtils.isBlank((String)document.getTitle()));
        document.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "", "2002", "", true);
        document.complete("");
        document = WorkflowDocumentFactory.loadDocument((String)"2002", (String)document.getDocumentId());
        document.approve("");
        Assert.assertEquals((String)"Should have transitioned nodes twice", (long)2L, (long)DocumentModifyingPostProcessor.levelChanges);
        Assert.assertTrue((String)"SHould have called the processed status change", (boolean)DocumentModifyingPostProcessor.processedChange);
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
        XMLAssert.assertXMLEqual((String)"Application content should have been sucessfully modified.", (String)APPLICATION_CONTENT, (String)document.getApplicationContent());
        Assert.assertEquals((String)"Wrong doc title", (Object)DOC_TITLE, (Object)document.getTitle());
        Assert.assertNotNull((String)"SHould have routed a document from the post processor.", (Object)DocumentModifyingPostProcessor.routedDocumentId);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DocumentModifyingPostProcessor.routedDocumentId);
        Assert.assertTrue((String)"document should be enroute", (boolean)document.isEnroute());
        Assert.assertEquals((String)"Document should have 1 pending request.", (long)1L, (long)KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId()).size());
        Assert.assertTrue((String)"ewestfal should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
    }

    @Test
    public void testEmptyPostProcessor() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"testEmptyPostProcessor");
        document.saveDocument("");
        Assert.assertEquals((String)"application content should be empty initially", (Object)"", (Object)document.getApplicationContent());
        Assert.assertTrue((String)"Doc title should be empty initially", (boolean)StringUtils.isBlank((String)document.getTitle()));
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
        DocumentType testEmptyDocType = KEWServiceLocator.getDocumentTypeService().findByName("testEmptyPostProcessor");
        Assert.assertTrue((String)"Post Processor should be set to 'none'", (boolean)StringUtils.equals((String)"none", (String)testEmptyDocType.getPostProcessorName()));
        Assert.assertTrue((String)"Post Processor should be of type DefaultPostProcessor", (boolean)(testEmptyDocType.getPostProcessor() instanceof DefaultPostProcessor));
    }

    @Override
    protected String getPrincipalIdForName(String principalName) {
        return KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName);
    }

    @Test
    public void RtestGetDocumentIdsToLock() throws Exception {
        WorkflowDocument documentB = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        documentB.saveDocument("");
        documentBId = documentB.getDocumentId();
        updateDocumentThread = new UpdateDocumentThread(documentBId);
        WorkflowDocument documentA = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"testGetDocumentIdsToLock");
        documentA.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName("rkirkend"), "", true);
        try {
            documentA.route("");
            Assert.fail((String)"An exception should have been thrown as the result of an optimistic lock!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        shouldReturnDocumentIdsToLock = true;
        documentB = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestDocumentType");
        documentB.saveDocument("");
        documentBId = documentB.getDocumentId();
        updateDocumentThread = new UpdateDocumentThread(documentBId);
        documentA = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"testGetDocumentIdsToLock");
        documentA.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName("rkirkend"), "", true);
        documentA.route("");
        documentA = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentA.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have approve request", (boolean)documentA.isApprovalRequested());
    }

    private class UpdateDocumentThread
    implements Runnable {
        private String documentId;

        public UpdateDocumentThread(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public void run() {
            TransactionTemplate template = new TransactionTemplate(KEWServiceLocator.getPlatformTransactionManager());
            template.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    KEWServiceLocator.getRouteHeaderService().lockRouteHeader(UpdateDocumentThread.this.documentId);
                    DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(UpdateDocumentThread.this.documentId);
                    document.setDocTitle(document.getDocTitle() + "UDT");
                    KEWServiceLocator.getRouteHeaderService().saveRouteHeader(document);
                    return null;
                }
            });
        }
    }

    public static class GetDocumentIdsToLockPostProcessor
    extends DefaultPostProcessor {
        protected String getPrincipalIdForName(String principalName) {
            return KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName);
        }

        public List<String> getDocumentIdsToLock(DocumentLockingEvent lockingEvent) throws Exception {
            WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)lockingEvent.getDocumentId());
            if (shouldReturnDocumentIdsToLock) {
                ArrayList<String> docIds = new ArrayList<String>();
                docIds.add(documentBId);
                return docIds;
            }
            return null;
        }

        public ProcessDocReport afterProcess(AfterProcessEvent event) throws Exception {
            WorkflowDocument wfDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)event.getDocumentId());
            if (wfDocument.isEnroute()) {
                DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentBId);
                new Thread(updateDocumentThread).start();
                Thread.sleep(5000L);
                document.setDocTitle(document.getDocTitle() + "...making a change...");
                KEWServiceLocator.getRouteHeaderService().saveRouteHeader(document);
            }
            return super.afterProcess(event);
        }
    }

    public static class DocumentModifyingPostProcessor
    extends DefaultPostProcessor {
        public static boolean processedChange = false;
        public static int levelChanges = 0;
        public static String routedDocumentId;

        protected String getPrincipalIdForName(String principalName) {
            return KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName);
        }

        public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
            if ("P".equals(statusChangeEvent.getNewRouteStatus())) {
                WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)statusChangeEvent.getDocumentId());
                document.setApplicationContent(PostProcessorTest.APPLICATION_CONTENT);
                document.setTitle(PostProcessorTest.DOC_TITLE);
                document.saveDocumentData();
                WorkflowDocument ppDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"testModifyDocumentInPostProcessor");
                routedDocumentId = ppDocument.getDocumentId();
                ppDocument.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "", "2001", "", true);
                ppDocument.route("");
                processedChange = true;
            }
            return new ProcessDocReport(true);
        }

        public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) throws Exception {
            WorkflowDocument document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)levelChangeEvent.getDocumentId());
            document.setTitle("Current level change: " + ++levelChanges);
            document.saveDocumentData();
            return new ProcessDocReport(true);
        }
    }
}

