/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routing;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class RoutingToInactiveWorkgroupTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RoutingConfig.xml");
    }

    @Test
    public void testRoutingToInactiveWorkgroup() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"InactiveWorkgroupDocType");
        try {
            doc.route("");
            Assert.fail((String)"document should have thrown routing exception");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestUtilities.getExceptionThreader().join();
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)doc.getDocumentId());
        Assert.assertTrue((String)"Document should be in exception routing because workgroup is inactive", (boolean)doc.isException());
        try {
            doc.route("routing a document that is in exception routing");
            Assert.fail((String)"Succeeded in routing document that is in exception routing");
        }
        catch (InvalidActionTakenException iate) {
            this.log.info("Expected exception occurred: " + (Object)((Object)iate));
        }
    }
}

