/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.test.KEWTestCase;
import org.xml.sax.InputSource;

public class NetworkIdRoleAttributeTest
extends KEWTestCase {
    private static final String ATTRIBUTE_NAME = "NetworkIdRoleAttribute";
    private static final String NETWORK_ID_PROP = "networkId";

    @Test
    public void testNetworkIdAttribute() throws Exception {
        this.loadXmlFile("NetworkIdRoleAttributeTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NetworkIdRoleAttributeTest");
        WorkflowAttributeDefinition.Builder networkIdDef1 = WorkflowAttributeDefinition.Builder.create((String)ATTRIBUTE_NAME);
        PropertyDefinition networkIdProp1 = PropertyDefinition.create((String)NETWORK_ID_PROP, (String)"rkirkend");
        networkIdDef1.addPropertyDefinition(networkIdProp1);
        WorkflowAttributeDefinition.Builder networkIdDef2 = WorkflowAttributeDefinition.Builder.create((String)ATTRIBUTE_NAME);
        PropertyDefinition networkIdProp2 = PropertyDefinition.create((String)NETWORK_ID_PROP, (String)"bmcgough");
        networkIdDef2.addPropertyDefinition(networkIdProp2);
        document.addAttributeDefinition(networkIdDef1.build());
        document.addAttributeDefinition(networkIdDef2.build());
        document.route("Routing!");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("i approve");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("i also approve");
        Assert.assertTrue((String)"Document should be FINAL", (boolean)document.isFinal());
    }

    @Test
    public void testParameterizedNetworkIdAttribute() throws Exception {
        this.loadXmlFile("ParameterizedNetworkIdRoleAttributeTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NetworkIdRoleAttributeTest");
        WorkflowAttributeDefinition.Builder networkIdDef1 = WorkflowAttributeDefinition.Builder.create((String)ATTRIBUTE_NAME);
        PropertyDefinition networkIdProp1 = PropertyDefinition.create((String)NETWORK_ID_PROP, (String)"rkirkend");
        networkIdDef1.addPropertyDefinition(networkIdProp1);
        document.addAttributeDefinition(networkIdDef1.build());
        document.route("Routing!");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        XPath xPath = XPathHelper.newXPath();
        Assert.assertTrue((String)"Should have found the ID.", (boolean)((Boolean)xPath.evaluate("//NetworkIdRoleAttribute/thisIdRocks", new InputSource(new StringReader(document.getDocumentContent().getFullContent())), XPathConstants.BOOLEAN)));
    }
}

