/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.kew.batch.KEWXmlDataLoader;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.service.RuleServiceInternal;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kew.xml.RuleXmlParser;

public class RuleXmlParserTest
extends KEWTestCase {
    private static final Logger LOG = LogManager.getLogger(RuleXmlParserTest.class);

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("RouteTemplateConfig.xml");
        this.loadXmlFile("DuplicateRuleToImport.xml");
    }

    @Test
    public void testRuleXmlParserCacheUpdate() throws Exception {
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        int ruleSize = ruleService.fetchAllCurrentRulesForTemplateDocCombination("TestRuleTemplate", "TestDocumentType").size();
        ArrayList<FileXmlDocCollection> collections = new ArrayList<FileXmlDocCollection>();
        InputStream xmlFile = TestUtilities.loadResource(((Object)((Object)this)).getClass(), "RulesToImport.xml");
        collections.add(KEWXmlDataLoader.getFileXmlDocCollection((InputStream)xmlFile, (String)"WorkflowUnitTestTemp"));
        CoreApiServiceLocator.getXmlIngesterService().ingest(collections, null);
        Thread.sleep(5000L);
        int newRuleSize = ruleService.fetchAllCurrentRulesForTemplateDocCombination("TestRuleTemplate", "TestDocumentType").size();
        Assert.assertEquals((String)"Three more rules should have been returned from the cached service", (long)(ruleSize + 3), (long)newRuleSize);
    }

    @Test
    public void testDuplicateRule() throws IOException, XmlException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("DuplicateRuleToImport.xml");
        Assert.assertNotNull((Object)stream);
        this.log.info("Importing duplicate again");
        try {
            KEWServiceLocator.getRuleService().loadXml(stream, null);
        }
        catch (WorkflowServiceErrorException wsee) {
            Assert.assertNotNull((Object)TestUtilities.findExceptionInStack(wsee, XmlException.class));
        }
    }

    @Test
    public void testDuplicateRuleWithExpression() throws IOException, XmlException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("DuplicateRuleToImportWithExpression.xml");
        Assert.assertNotNull((Object)stream);
        this.log.info("Importing duplicate again");
        try {
            KEWServiceLocator.getRuleService().loadXml(stream, null);
        }
        catch (WorkflowServiceErrorException wsee) {
            Assert.assertNotNull((Object)TestUtilities.findExceptionInStack(wsee, XmlException.class));
        }
    }

    @Test
    public void testNotDuplicateRule() throws IOException, XmlException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("NotADuplicateRuleToImport.xml");
        Assert.assertNotNull((Object)stream);
        this.log.info("Importing a unique rule");
        KEWServiceLocator.getRuleTemplateService().loadXml(stream, null);
        stream = ((Object)((Object)this)).getClass().getResourceAsStream("NotADuplicateRuleToImport.xml");
        KEWServiceLocator.getRuleService().loadXml(stream, null);
    }

    @Test
    public void testNotDuplicateRuleWithExpression() throws IOException, XmlException {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("NotADuplicateRuleToImportWithExpression.xml");
        Assert.assertNotNull((Object)stream);
        this.log.info("Importing a unique rule");
        KEWServiceLocator.getRuleTemplateService().loadXml(stream, null);
        stream = ((Object)((Object)this)).getClass().getResourceAsStream("NotADuplicateRuleToImportWithExpression.xml");
        KEWServiceLocator.getRuleService().loadXml(stream, null);
    }

    private static RuleExtensionValue getExtensionValue(List<RuleExtensionValue> list, String name) {
        for (RuleExtensionValue extensionValue : list) {
            if (!name.equals(extensionValue.getKey())) continue;
            return extensionValue;
        }
        return null;
    }

    @Test
    public void testNamedRule() {
        this.loadXmlFile("NamedRule.xml");
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        RuleBaseValues rule = ruleService.getRuleByName("ANamedRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((Object)"ANamedRule", (Object)rule.getName());
        Assert.assertEquals((Object)"A named rule", (Object)rule.getDescription());
        LOG.info("Before Testing  To and From Dates : " + rule.getToDateString() + " " + rule.getFromDateString());
        Assert.assertNull((Object)rule.getToDateString());
        Assert.assertNull((Object)rule.getFromDateString());
        LOG.info("Rule To and From Dates : " + rule.getDocTypeName() + " " + rule.getName());
        List extensions = rule.getRuleExtensions();
        Assert.assertEquals((long)1L, (long)extensions.size());
        RuleExtensionBo extension = (RuleExtensionBo)extensions.get(0);
        Assert.assertEquals((Object)"TestRuleAttribute", (Object)extension.getRuleTemplateAttribute().getRuleAttribute().getName());
        List extensionValues = extension.getExtensionValues();
        Assert.assertEquals((long)2L, (long)extensionValues.size());
        RuleExtensionValue extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "color");
        Assert.assertEquals((Object)"color", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"green", (Object)extensionValue.getValue());
        extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "shape");
        Assert.assertEquals((Object)"shape", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"square", (Object)extensionValue.getValue());
        List responsibilities = rule.getRuleResponsibilities();
        Assert.assertEquals((long)1L, (long)responsibilities.size());
        RuleResponsibilityBo responsibility = (RuleResponsibilityBo)responsibilities.get(0);
        Assert.assertEquals((Object)"user1", (Object)responsibility.getPrincipal().getPrincipalName());
        Assert.assertEquals((Object)"A", (Object)responsibility.getActionRequestedCd());
    }

    @Test
    public void testNamedRuleWithExpression() {
        this.loadXmlFile("NamedRuleWithExpression.xml");
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        RuleBaseValues rule = ruleService.getRuleByName("ANamedRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((Object)"ANamedRule", (Object)rule.getName());
        Assert.assertEquals((Object)"A named rule", (Object)rule.getDescription());
        List extensions = rule.getRuleExtensions();
        Assert.assertEquals((long)1L, (long)extensions.size());
        RuleExtensionBo extension = (RuleExtensionBo)extensions.get(0);
        Assert.assertEquals((Object)"TestRuleAttribute", (Object)extension.getRuleTemplateAttribute().getRuleAttribute().getName());
        List extensionValues = extension.getExtensionValues();
        Assert.assertEquals((long)2L, (long)extensionValues.size());
        RuleExtensionValue extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "color");
        Assert.assertEquals((Object)"color", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"green", (Object)extensionValue.getValue());
        extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "shape");
        Assert.assertEquals((Object)"shape", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"square", (Object)extensionValue.getValue());
        List responsibilities = rule.getRuleResponsibilities();
        Assert.assertEquals((long)1L, (long)responsibilities.size());
        RuleResponsibilityBo responsibility = (RuleResponsibilityBo)responsibilities.get(0);
        Assert.assertEquals((Object)"user1", (Object)responsibility.getPrincipal().getPrincipalName());
        Assert.assertEquals((Object)"A", (Object)responsibility.getActionRequestedCd());
        Assert.assertNotNull((Object)rule.getRuleExpressionDef());
        Assert.assertEquals((Object)"someType", (Object)rule.getRuleExpressionDef().getType());
        Assert.assertEquals((Object)"some expression", (Object)rule.getRuleExpressionDef().getExpression());
    }

    @Test
    public void testUpdatedRule() {
        this.testNamedRule();
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        RuleBaseValues rule = ruleService.getRuleByName("ANamedRule");
        String responsibilityId = ((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getResponsibilityId();
        String ruleId = rule.getId();
        Integer versionNumber = rule.getVersionNbr();
        this.loadXmlFile("UpdatedNamedRule.xml");
        rule = ruleService.getRuleByName("ANamedRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((Object)"ANamedRule", (Object)rule.getName());
        Assert.assertTrue((String)"Rule should be current.", (boolean)rule.getCurrentInd());
        Assert.assertFalse((String)"Rule should not be a delegate rule.", (boolean)rule.getDelegateRule());
        Assert.assertFalse((String)"Rule should not be a template rule.", (boolean)rule.getTemplateRuleInd());
        Assert.assertNull((String)"Rule should not have a from date.", (Object)rule.getFromDateValue());
        Assert.assertNull((String)"Rule should not have a to date.", (Object)rule.getToDateValue());
        Assert.assertFalse((String)"Rule ids should be different", (boolean)ruleId.equals(rule.getId()));
        Assert.assertEquals((String)"Previous version id should be correct", (Object)ruleId, (Object)rule.getPreviousRuleId());
        Assert.assertEquals((String)"Version ids are incorrect", (Object)new Integer(versionNumber + 1), (Object)rule.getVersionNbr());
        RuleBaseValues oldRule = ruleService.findRuleBaseValuesById(ruleId);
        Assert.assertFalse((String)"Old rule should no longer be current.", (boolean)oldRule.getCurrentInd());
        Assert.assertEquals((Object)"A named rule with an updated description, rule extension values, and responsibilities", (Object)rule.getDescription());
        List extensions = rule.getRuleExtensions();
        Assert.assertEquals((long)1L, (long)extensions.size());
        RuleExtensionBo extension = (RuleExtensionBo)extensions.get(0);
        Assert.assertEquals((Object)"TestRuleAttribute", (Object)extension.getRuleTemplateAttribute().getRuleAttribute().getName());
        List extensionValues = extension.getExtensionValues();
        Assert.assertEquals((long)2L, (long)extensionValues.size());
        RuleExtensionValue extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "flavor");
        Assert.assertEquals((Object)"flavor", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"vanilla", (Object)extensionValue.getValue());
        extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "value");
        Assert.assertEquals((Object)"value", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"10", (Object)extensionValue.getValue());
        List responsibilities = rule.getRuleResponsibilities();
        Assert.assertEquals((long)2L, (long)responsibilities.size());
        RuleResponsibilityBo responsibility = (RuleResponsibilityBo)responsibilities.get(0);
        Assert.assertEquals((Object)responsibilityId, (Object)responsibility.getResponsibilityId());
        Assert.assertEquals((Object)"user1", (Object)responsibility.getPrincipal().getPrincipalName());
        Assert.assertEquals((Object)"A", (Object)responsibility.getActionRequestedCd());
        Assert.assertEquals((Object)new Integer(1), (Object)responsibility.getPriority());
        responsibility = (RuleResponsibilityBo)responsibilities.get(1);
        Assert.assertFalse((boolean)responsibilityId.equals(responsibility.getResponsibilityId()));
        Assert.assertEquals((Object)"user2", (Object)responsibility.getPrincipal().getPrincipalName());
        Assert.assertEquals((Object)"F", (Object)responsibility.getActionRequestedCd());
        Assert.assertEquals((Object)new Integer(1), (Object)responsibility.getPriority());
    }

    @Test
    public void testUpdatedRuleWithExpression() {
        this.testNamedRule();
        this.loadXmlFile("UpdatedNamedRuleWithExpression.xml");
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        RuleBaseValues rule = ruleService.getRuleByName("ANamedRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((Object)"ANamedRule", (Object)rule.getName());
        Assert.assertEquals((Object)"A named rule with an updated description, rule extension values, and responsibilities", (Object)rule.getDescription());
        List extensions = rule.getRuleExtensions();
        Assert.assertEquals((long)1L, (long)extensions.size());
        RuleExtensionBo extension = (RuleExtensionBo)extensions.get(0);
        Assert.assertEquals((Object)"TestRuleAttribute", (Object)extension.getRuleTemplateAttribute().getRuleAttribute().getName());
        List extensionValues = extension.getExtensionValues();
        Assert.assertEquals((long)2L, (long)extensionValues.size());
        RuleExtensionValue extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "flavor");
        Assert.assertEquals((Object)"flavor", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"vanilla", (Object)extensionValue.getValue());
        extensionValue = RuleXmlParserTest.getExtensionValue(extensionValues, "value");
        Assert.assertEquals((Object)"value", (Object)extensionValue.getKey());
        Assert.assertEquals((Object)"10", (Object)extensionValue.getValue());
        List responsibilities = rule.getRuleResponsibilities();
        Assert.assertEquals((long)1L, (long)responsibilities.size());
        RuleResponsibilityBo responsibility = (RuleResponsibilityBo)responsibilities.get(0);
        Assert.assertEquals((Object)"user2", (Object)responsibility.getPrincipal().getPrincipalName());
        Assert.assertEquals((Object)"F", (Object)responsibility.getActionRequestedCd());
    }

    @Test
    public void testAnonymousDuplicatesNamed() {
        this.testNamedRule();
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("DuplicateAnonymousRule.xml");
        Assert.assertNotNull((Object)stream);
        this.log.info("Importing anonymous duplicate rule");
        try {
            KEWServiceLocator.getRuleService().loadXml(stream, null);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (WorkflowServiceErrorException e) {
            Assert.assertNotNull((String)"Expected exception was not thrown", (Object)TestUtilities.findExceptionInStack(e.getCause(), XmlException.class));
        }
    }

    @Test
    public void testAnonymousWithExpressionDuplicatesNamed() {
        this.testNamedRuleWithExpression();
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("DuplicateAnonymousRuleWithExpression.xml");
        Assert.assertNotNull((Object)stream);
        this.log.info("Importing anonymous duplicate rule");
        try {
            KEWServiceLocator.getRuleService().loadXml(stream, null);
            Assert.fail((String)"Expected exception was not thrown");
        }
        catch (WorkflowServiceErrorException e) {
            Assert.assertNotNull((String)"Expected exception was not thrown", (Object)TestUtilities.findExceptionInStack(e.getCause(), XmlException.class));
        }
    }

    @Test
    public void testParameterReplacement() throws IOException, XmlException {
        ConfigContext.getCurrentContextConfig().putProperty("test.replacement.user", "user3");
        ConfigContext.getCurrentContextConfig().putProperty("test.replacement.workgroup", "WorkflowAdmin");
        List rules = new RuleXmlParser().parseRules(((Object)((Object)this)).getClass().getResourceAsStream("ParameterizedRule.xml"));
        Assert.assertEquals((long)1L, (long)rules.size());
        RuleBaseValues rule = (RuleBaseValues)rules.get(0);
        Assert.assertEquals((long)2L, (long)rule.getRuleResponsibilities().size());
        RuleResponsibilityBo resp = (RuleResponsibilityBo)rule.getRuleResponsibilities().get(0);
        if (resp.isUsingPrincipal()) {
            Assert.assertEquals((Object)"user3", (Object)resp.getPrincipal().getPrincipalName());
        } else {
            Assert.assertEquals((Object)"WorkflowAdmin", (Object)resp.getGroup().getName());
        }
        ConfigContext.getCurrentContextConfig().putProperty("test.replacement.user", "user1");
        ConfigContext.getCurrentContextConfig().putProperty("test.replacement.workgroup", "TestWorkgroup");
        rules = new RuleXmlParser().parseRules(((Object)((Object)this)).getClass().getResourceAsStream("ParameterizedRule.xml"));
        Assert.assertEquals((long)1L, (long)rules.size());
        rule = (RuleBaseValues)rules.get(0);
        Assert.assertEquals((long)2L, (long)rule.getRuleResponsibilities().size());
        resp = (RuleResponsibilityBo)rule.getRuleResponsibilities().get(0);
        if (resp.isUsingPrincipal()) {
            Assert.assertEquals((Object)"user1", (Object)resp.getPrincipal().getPrincipalName());
        } else {
            Assert.assertEquals((Object)"TestWorkgroup", (Object)resp.getGroup().getName());
        }
    }

    @Test
    public void removeTemplateFromNamedRule() {
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        int originalRuleCount = ruleService.fetchAllCurrentRulesForTemplateDocCombination("TestRuleTemplate", "TestDocumentType").size();
        this.testNamedRule();
        LOG.debug("Rules for doctype/template combo:");
        int ruleCount = 0;
        List list = ruleService.fetchAllCurrentRulesForTemplateDocCombination("TestRuleTemplate", "TestDocumentType");
        if (list != null) {
            ruleCount = list.size();
            for (Object rbv : list) {
                LOG.info(rbv);
            }
        }
        this.loadXmlFile("NamedRuleWithoutTemplate.xml");
        LOG.debug("Rules for doctype/template combo after import of named rule:");
        int ruleCountAfter = 0;
        list = ruleService.fetchAllCurrentRulesForTemplateDocCombination("TestRuleTemplate", "TestDocumentType");
        if (list != null) {
            ruleCountAfter = list.size();
            for (RuleBaseValues rbv : list) {
                LOG.info((Object)rbv);
            }
        }
        RuleBaseValues rule = ruleService.getRuleByName("ANamedRule");
        Assert.assertNotNull((Object)rule);
        LOG.info("Rule id of latest version: " + rule.getId());
        Assert.assertEquals((Object)"ANamedRule", (Object)rule.getName());
        Assert.assertEquals((Object)"A named rule with previously defined template removed", (Object)rule.getDescription());
        Assert.assertEquals((String)"The rules for template/doctype combo should have been decreased by one after reimport of named rule without template", (long)(ruleCount - 1), (long)ruleCountAfter);
        Assert.assertEquals((String)"Rule count should be original template/doctype combo rule count after removing template from named rule", (long)originalRuleCount, (long)ruleCountAfter);
        Assert.assertNull((Object)rule.getRuleTemplate());
        List extensions = rule.getRuleExtensions();
        Assert.assertEquals((long)0L, (long)extensions.size());
        List responsibilities = rule.getRuleResponsibilities();
        Assert.assertEquals((long)1L, (long)responsibilities.size());
        RuleResponsibilityBo responsibility = (RuleResponsibilityBo)responsibilities.get(0);
        Assert.assertEquals((Object)"user2", (Object)responsibility.getPrincipal().getPrincipalName());
        Assert.assertEquals((Object)"F", (Object)responsibility.getActionRequestedCd());
    }

    @Test
    public void testInvalidTemplatelessNamedRule() {
        this.testNamedRule();
        try {
            this.loadXmlFile("InvalidTemplatelessNamedRule.xml");
            Assert.fail((String)"Rule should have failed to load because it attempts to define extensions on a templateless rule.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRulesWithDifferentResponsibilityTypes() throws Exception {
        this.loadXmlFile("RulesWithDifferentResponsibilityTypes.xml");
        RuleServiceInternal ruleService = KEWServiceLocator.getRuleService();
        RuleBaseValues rule = ruleService.getRuleByName("RespTypeTest1");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((String)"Rule should have a principal responsibility", (Object)"F", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Rule should have a principal id of user1", (Object)"user1", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityName());
        rule = ruleService.getRuleByName("RespTypeTest2");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((String)"Rule should have a principal responsibility", (Object)"F", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Rule should have a principal id of user1", (Object)"user1", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityName());
        rule = ruleService.getRuleByName("RespTypeTest3");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((String)"Rule should have a group responsibility", (Object)"G", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Rule should have a group id of 3001", (Object)"3001", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityName());
        rule = ruleService.getRuleByName("RespTypeTest4");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((String)"Rule should have a group responsibility", (Object)"G", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Rule should have a group id of 1", (Object)"1", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityName());
        rule = ruleService.getRuleByName("RespTypeTest5");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((String)"Rule should have a role responsibility", (Object)"R", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Invalid role name", (Object)"org.kuali.rice.kew.rule.TestRuleAttribute!TEST", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityName());
        rule = ruleService.getRuleByName("RespTypeTest6");
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((String)"Rule should have a role responsibility", (Object)"R", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityType());
        Assert.assertEquals((String)"Invalid role name", (Object)"org.kuali.rice.kew.rule.TestRuleAttribute!TEST", (Object)((RuleResponsibilityBo)rule.getRuleResponsibilities().get(0)).getRuleResponsibilityName());
    }
}

