/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.service.impl;

import java.util.List;
import javax.persistence.PersistenceException;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.util.LegacyUtils;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.dao.DataIntegrityViolationException;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RuleServiceTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("org/kuali/rice/kew/rule/RouteTemplateConfig.xml");
    }

    @Test
    public void testEmptyRuleExtension() throws Exception {
        block2: {
            RuleBaseValues rbv = new RuleBaseValues();
            rbv.setActive(Boolean.TRUE.booleanValue());
            rbv.setCurrentInd(Boolean.TRUE);
            rbv.setDescription("A test rule");
            rbv.setDocTypeName("TestDocumentType");
            rbv.setForceAction(Boolean.FALSE.booleanValue());
            RuleExtensionBo ext = new RuleExtensionBo();
            RuleExtensionValue val = new RuleExtensionValue();
            val.setKey("emptyvalue");
            val.setValue("");
            ext.getExtensionValues().add(val);
            rbv.getRuleExtensions().add(ext);
            boolean isKewJpaEnabled = !LegacyUtils.isLegacyDataFrameworkEnabled();
            try {
                KEWServiceLocator.getRuleService().save2(rbv);
                Assert.fail((String)"exception did not happen");
            }
            catch (RuntimeException e) {
                boolean fail;
                boolean bl = fail = !isKewJpaEnabled ? e instanceof PersistenceException : e instanceof DataIntegrityViolationException;
                if (!fail) break block2;
                Assert.fail((String)"Did not throw exception as expected.  If rule service behavior has changed, update this test.");
            }
        }
    }

    @Test
    public void testRetrievalOfRulesWithoutResponsibilities() throws Exception {
        int i;
        this.loadXmlFile("org/kuali/rice/kew/rule/RulesWithoutResponsibilities.xml");
        String NULL_ID = null;
        String[] expectedRuleNames = new String[]{"NoResponsibilitiesRule1", "NoResponsibilitiesRule2", "NoResponsibilitiesRule3"};
        String[] expectedRuleDocTypes = new String[]{"RiceDocument.RuleDocument", "RiceDocument.child1", "RiceDocument.child1child"};
        String[] expectedRuleDescriptions = new String[]{"A rule with no responsibilities", "Another rule without responsibilities", "A third rule lacking responsibilities"};
        String[] personResponsibilities = new String[]{"rkirkend", "rkirkend", "user1"};
        String[] groupResponsibilities = new String[]{"TestWorkgroup", "NonSIT", "TestWorkgroup"};
        int actualResponsibilitylessRuleCount = 0;
        List ruleList = null;
        ruleList = KEWServiceLocator.getRuleService().search(null, NULL_ID, null, null, null, null, null, null, null, "");
        Assert.assertNotNull((String)"The returned rule list should not be null", (Object)ruleList);
        for (RuleBaseValues rBaseValues : ruleList) {
            if (rBaseValues.getRuleResponsibilities() != null && !rBaseValues.getRuleResponsibilities().isEmpty()) continue;
            ++actualResponsibilitylessRuleCount;
        }
        Assert.assertEquals((String)"Wrong number of responsibility-less rules found", (long)expectedRuleNames.length, (long)actualResponsibilitylessRuleCount);
        for (i = 0; i < expectedRuleNames.length; ++i) {
            RuleBaseValues rBaseValues;
            ruleList = KEWServiceLocator.getRuleService().search(expectedRuleDocTypes[i], NULL_ID, null, expectedRuleDescriptions[i], null, null, null, null, null, "");
            Assert.assertNotNull((String)("The returned rule list should not be null when searching for rule '" + expectedRuleNames[i] + "'"), (Object)ruleList);
            Assert.assertEquals((String)("Exactly one rule should have been retrieved when searching for rule '" + expectedRuleNames[i] + "'"), (long)1L, (long)ruleList.size());
            rBaseValues = (RuleBaseValues)ruleList.get(0);
            Assert.assertEquals((String)"The retrieved rule has the wrong name", (Object)expectedRuleNames[i], (Object)rBaseValues.getName());
            Assert.assertEquals((String)("Rule '" + expectedRuleNames[i] + "' has the wrong doc type name"), (Object)expectedRuleDocTypes[i], (Object)rBaseValues.getDocTypeName());
            Assert.assertEquals((String)("Rule '" + expectedRuleNames[i] + "' has the wrong description"), (Object)expectedRuleDescriptions[i], (Object)rBaseValues.getDescription());
            Assert.assertTrue((String)("Rule '" + expectedRuleNames[i] + "' should not have any responsibilities"), (rBaseValues.getRuleResponsibilities() == null || rBaseValues.getRuleResponsibilities().isEmpty() ? 1 : 0) != 0);
        }
        for (i = 0; i < expectedRuleNames.length; ++i) {
            ruleList = KEWServiceLocator.getRuleService().search(expectedRuleDocTypes[i], NULL_ID, null, null, null, KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName(personResponsibilities[i]).getPrincipalId(), null, null, null, "user");
            Assert.assertNotNull((String)("The returned rule list should not be null for doc type '" + expectedRuleDocTypes[i] + "'"), (Object)ruleList);
            Assert.assertFalse((String)("The returned rule list should not be empty for doc type '" + expectedRuleDocTypes[i] + "'"), (boolean)ruleList.isEmpty());
            for (RuleBaseValues rBaseValues : ruleList) {
                Assert.assertTrue((String)("Found a rule without responsibilities for doc type '" + expectedRuleDocTypes[i] + "' and principal '" + personResponsibilities[i] + "'"), (rBaseValues.getRuleResponsibilities() != null && !rBaseValues.getRuleResponsibilities().isEmpty() ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < expectedRuleNames.length; ++i) {
            ruleList = KEWServiceLocator.getRuleService().search(expectedRuleDocTypes[i], NULL_ID, null, null, KEWServiceLocator.getIdentityHelperService().getGroupByName("KR-WKFLW", groupResponsibilities[i]).getId(), null, null, null, null, "");
            Assert.assertNotNull((String)("The returned rule list should not be null for doc type '" + expectedRuleDocTypes[i] + "'"), (Object)ruleList);
            Assert.assertFalse((String)("The returned rule list should not be empty for doc type '" + expectedRuleDocTypes[i] + "'"), (boolean)ruleList.isEmpty());
            for (RuleBaseValues rBaseValues : ruleList) {
                Assert.assertTrue((String)("Found a rule without responsibilities for doc type '" + expectedRuleDocTypes[i] + "' and group '" + groupResponsibilities[i] + "' with namespace 'KR-WKFLW'"), (rBaseValues.getRuleResponsibilities() != null && !rBaseValues.getRuleResponsibilities().isEmpty() ? 1 : 0) != 0);
            }
        }
    }
}

