/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.util.ClasspathOrFileResourceLoader;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.kuali.rice.coreservice.impl.CoreServiceImplServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.batch.KEWXmlDataLoader;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.test.BaselineTestCase;
import org.kuali.rice.test.ClearDatabaseLifecycle;
import org.kuali.rice.test.SQLDataLoader;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.kuali.rice.test.lifecycles.KEWXmlDataLoaderLifecycle;
import org.kuali.rice.test.runners.LoadTimeWeavableTestRunner;
import org.springframework.cache.CacheManager;
import org.springframework.transaction.support.TransactionTemplate;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
@RunWith(value=LoadTimeWeavableTestRunner.class)
@org.kuali.rice.test.runners.BootstrapTest(value=BootstrapTest.class)
public abstract class KEWTestCase
extends BaselineTestCase {
    private static final String SQL_FILE = "classpath:org/kuali/rice/kew/test/DefaultSuiteTestData.sql";
    private static final String XML_FILE = "classpath:org/kuali/rice/kew/test/DefaultSuiteTestData.xml";
    private static final String KRAD_MODULE_NAME = "kew";

    public KEWTestCase() {
        super(KRAD_MODULE_NAME);
    }

    protected List<Lifecycle> getSuiteLifecycles() {
        List suiteLifecycles = super.getSuiteLifecycles();
        suiteLifecycles.add(new KEWXmlDataLoaderLifecycle(XML_FILE));
        return suiteLifecycles;
    }

    protected void loadSuiteTestData() throws Exception {
        super.loadSuiteTestData();
        new SQLDataLoader(SQL_FILE, ";").runSql();
    }

    protected void loadDefaultTestData() throws Exception {
        new SQLDataLoader("classpath:org/kuali/rice/kew/test/DefaultPerTestData.sql", ";").runSql();
        KEWXmlDataLoader.loadXmlClassLoaderResource(KEWTestCase.class, (String)"DefaultPerTestData.xml");
    }

    protected Lifecycle getLoadApplicationLifecycle() {
        SpringResourceLoader springResourceLoader = new SpringResourceLoader(new QName("KEWTestResourceLoader"), "classpath:org/kuali/rice/kew/config/TestKEWSpringBeans.xml", null);
        springResourceLoader.setParentSpringResourceLoader(this.getTestHarnessSpringResourceLoader());
        return springResourceLoader;
    }

    protected void setUpAfterDataLoad() throws Exception {
    }

    protected void loadTestData() throws Exception {
    }

    protected TransactionTemplate getTransactionTemplate() {
        return TestUtilities.getTransactionTemplate();
    }

    protected void loadPerTestData() throws Exception {
        long t1 = System.currentTimeMillis();
        this.loadDefaultTestData();
        long t2 = System.currentTimeMillis();
        this.loadTestData();
        long t3 = System.currentTimeMillis();
        this.report("Time to load test-specific test data: " + (t3 - t2));
        this.setUpAfterDataLoad();
        long t4 = System.currentTimeMillis();
        this.report("Time to run test-specific setup: " + (t4 - t3));
    }

    protected List<Lifecycle> getPerTestLifecycles() {
        ArrayList<Lifecycle> lifecycles = new ArrayList<Lifecycle>();
        lifecycles.add((Lifecycle)new ClearDatabaseLifecycle(this.getPerTestTablesToClear(), this.getPerTestTablesNotToClear()));
        lifecycles.add((Lifecycle)new ClearCacheLifecycle());
        lifecycles.addAll(super.getPerTestLifecycles());
        return lifecycles;
    }

    protected void clearCacheManagers(CacheManager ... cacheManagers) {
        for (CacheManager cacheManager : cacheManagers) {
            for (String cacheName : cacheManager.getCacheNames()) {
                this.LOG.info("Clearing cache: " + cacheName);
                cacheManager.getCache(cacheName).clear();
            }
        }
    }

    protected List<String> getPerTestTablesToClear() {
        ArrayList<String> tablesToClear = new ArrayList<String>();
        tablesToClear.add("KREW_.*");
        tablesToClear.add("KRSB_.*");
        tablesToClear.add("KREN_.*");
        tablesToClear.add("KRMS_.*");
        return tablesToClear;
    }

    protected List<String> getPerTestTablesNotToClear() {
        return new ArrayList<String>();
    }

    protected void loadXmlFile(String fileName) {
        try {
            KEWXmlDataLoader.loadXmlClassLoaderResource(((Object)((Object)this)).getClass(), (String)fileName);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected void loadXmlFile(Class clazz, String fileName) {
        try {
            KEWXmlDataLoader.loadXmlClassLoaderResource((Class)clazz, (String)fileName);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected void loadXmlFileFromFileSystem(String fileName) {
        try {
            KEWXmlDataLoader.loadXmlFile((String)new ClasspathOrFileResourceLoader().getResource(fileName).getURL().getPath());
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected void loadXmlStream(InputStream xmlStream) {
        try {
            KEWXmlDataLoader.loadXmlStream((InputStream)xmlStream);
        }
        catch (Exception e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    protected String getPrincipalIdForName(String principalName) {
        return KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(principalName).getPrincipalId();
    }

    protected String getPrincipalNameForId(String principalId) {
        return KimApiServiceLocator.getIdentityService().getPrincipal(principalId).getPrincipalName();
    }

    protected String getGroupIdForName(String namespace, String groupName) {
        return KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(namespace, groupName).getId();
    }

    protected Long getNextSequenceLongValue(String sequenceName) {
        return MaxValueIncrementerFactory.getIncrementer((DataSource)TestHarnessServiceLocator.getDataSource(), (String)sequenceName).nextLongValue();
    }

    protected String getNextSequenceStringValue(String sequenceName) {
        return MaxValueIncrementerFactory.getIncrementer((DataSource)TestHarnessServiceLocator.getDataSource(), (String)sequenceName).nextStringValue();
    }

    protected String getRoleIdForName(String namespace, String roleName) {
        Role role = KimApiServiceLocator.getRoleService().getRoleByNamespaceCodeAndName(namespace, roleName);
        return role == null ? null : role.getId();
    }

    public static final class BootstrapTest
    extends KEWTestCase {
        @Test
        public void bootstrapTest() {
        }
    }

    public class ClearCacheLifecycle
    extends BaseLifecycle {
        public void stop() throws Exception {
            KEWTestCase.this.clearCacheManagers(KimImplServiceLocator.getLocalCacheManager(), KEWServiceLocator.getLocalCacheManager(), CoreServiceImplServiceLocator.getLocalCacheManager());
            super.stop();
        }
    }
}

