/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.impl.impex.xml.ClassLoaderEntityResolver;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.DocumentTypeAttributeBo;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.xml.DocumentTypeXmlParser;
import org.kuali.rice.krad.exception.GroupNotFoundException;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentTypeXmlParserTest
extends KEWTestCase {
    private static String applicationStatusDocumentTypeTemplate;

    @BeforeClass
    public static void beforeClass() throws Exception {
        applicationStatusDocumentTypeTemplate = IOUtils.toString((InputStream)DocumentTypeXmlParserTest.class.getResourceAsStream("BadKEWAppDocStatusTemplate.xml"));
    }

    private boolean validate(String docName) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver((EntityResolver)new ClassLoaderEntityResolver());
        db.setErrorHandler(new DefaultHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                this.fatalError(e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                super.fatalError(e);
            }
        });
        try {
            db.parse(((Object)((Object)this)).getClass().getResourceAsStream(docName + ".xml"));
            return true;
        }
        catch (SAXException se) {
            this.log.error("Error validating " + docName + ".xml", (Throwable)se);
            return false;
        }
    }

    private List<DocumentType> testDoc(String docName, Class expectedException) throws Exception {
        return this.testDoc(docName, true, expectedException);
    }

    private List<DocumentType> testDoc(String docName, boolean valid, Class expectedException) throws Exception {
        Assert.assertEquals((Object)valid, (Object)this.validate(docName));
        DocumentTypeXmlParser parser = new DocumentTypeXmlParser();
        try {
            List docTypes = parser.parseDocumentTypes(((Object)((Object)this)).getClass().getResourceAsStream(docName + ".xml"));
            if (expectedException != null) {
                Assert.fail((String)(docName + " successfully loaded"));
            }
            return docTypes;
        }
        catch (Exception e) {
            if (expectedException == null || !expectedException.isAssignableFrom(e.getClass())) {
                throw e;
            }
            this.log.error(docName + " exception: " + e);
            return new ArrayList<DocumentType>();
        }
    }

    @Test
    public void testLoadOverwriteDocumentType() throws Exception {
        this.testDoc("OverwriteDocumentType", null);
        Assert.assertNotNull((String)"Document type should exist after ingestion", (Object)KEWServiceLocator.getDocumentTypeService().findByName("DocumentTypeXmlParserTestDoc_OverwriteDocumentType"));
    }

    @Test
    public void testLoadDocWithVariousActivationTypes() throws Exception {
        this.testDoc("ValidActivationTypes", null);
    }

    @Test
    public void testLoadDocWithInvalidActivationType() throws Exception {
        this.testDoc("BadActivationType", false, IllegalArgumentException.class);
    }

    @Test
    public void testLoadDocWithValidPolicyNames() throws Exception {
        this.testDoc("ValidPolicyNames", null);
    }

    @Test
    public void testLoadDocWithValidRuleSelector() throws Exception {
        this.testDoc("ValidRuleSelector", null);
    }

    @Test
    public void testLoadDocWithDuplicatePolicyName() throws Exception {
        this.testDoc("DuplicatePolicyName", XmlException.class);
    }

    @Test
    public void testLoadDocWithBadPolicyName() throws Exception {
        this.testDoc("BadPolicyName", false, IllegalArgumentException.class);
    }

    @Test
    public void testLoadDocWithBadNextNode() throws Exception {
        this.testDoc("BadNextNode", XmlException.class);
    }

    @Test
    public void testLoadDocWithNoDocHandler() throws Exception {
        this.testDoc("NoDocHandler", null);
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("DocumentTypeXmlParserTestDoc1");
        Assert.assertTrue((String)"Doc type unresolved doc handler should be empty.", (boolean)StringUtils.isBlank((String)documentType.getUnresolvedDocHandlerUrl()));
        Assert.assertTrue((String)"Doc type doc handler should be empty.", (boolean)StringUtils.isBlank((String)documentType.getUnresolvedDocHandlerUrl()));
    }

    @Test
    public void testLoadDocWithBadExceptionWG() throws Exception {
        this.testDoc("BadExceptionWorkgroup", false, GroupNotFoundException.class);
    }

    @Test
    public void testLoadDocWithBadSuperUserWG() throws Exception {
        this.testDoc("BadSuperUserWorkgroup", false, GroupNotFoundException.class);
    }

    @Test
    public void testLoadDocWithBadBlanketApproveWG() throws Exception {
        this.testDoc("BadBlanketApproveWorkgroup", false, GroupNotFoundException.class);
    }

    @Test
    public void testLoadDocWithBadRuleTemplate() throws Exception {
        this.testDoc("BadRuleTemplate", XmlException.class);
    }

    @Test
    public void testLoadDocWithInvalidParent() throws Exception {
        this.testDoc("InvalidParent", XmlException.class);
    }

    @Test
    public void testLoadDocWithOrphanedNodes() throws Exception {
        this.testDoc("OrphanedNodes", XmlException.class);
    }

    @Test
    public void testBlanketApprovePolicy() throws Exception {
        this.testDoc("BlanketApprovePolicy", null);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy1");
        document.saveDocumentData();
        Assert.assertTrue((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy2");
        document.saveDocumentData();
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"BlanketApprovePolicy3");
        document.saveDocumentData();
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy5");
        document.saveDocumentData();
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy6");
        document.saveDocumentData();
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy7");
        document.saveDocumentData();
        Assert.assertTrue((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy_Override_NONE");
        document.saveDocumentData();
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy_Override_ANY");
        document.saveDocumentData();
        Assert.assertTrue((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("pzhang"), (String)"BlanketApprovePolicy_NoOverride");
        document.saveDocumentData();
        Assert.assertFalse((boolean)this.isActionCodeValidForDocument(document, "B"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)this.isActionCodeValidForDocument(document, "B"));
    }

    @Test
    public void testReportingWorkgroupName() throws Exception {
        this.testDoc("ReportingWorkgroupName", null);
        DocumentType documentType1 = KEWServiceLocator.getDocumentTypeService().findByName("ReportingWorkgroupName1");
        Assert.assertNotNull((String)"Should have a reporting workgroup.", (Object)documentType1.getReportingWorkgroup());
        Assert.assertEquals((String)"Should be WorkflowAdmin reporting workgroup", (Object)"WorkflowAdmin", (Object)documentType1.getReportingWorkgroup().getName());
        DocumentType documentType2 = KEWServiceLocator.getDocumentTypeService().findByName("ReportingWorkgroupName2");
        Assert.assertNull((String)"Should not have a reporting workgroup.", (Object)documentType2.getReportingWorkgroup());
    }

    @Test
    public void testCurrentDocumentNotMaxVersionNumber() throws Exception {
        String fileNameToIngest = "VersionNumberCheck";
        String documentTypeName = "VersionCheckDocument";
        this.testDoc(fileNameToIngest, null);
        this.testDoc(fileNameToIngest, null);
        this.testDoc(fileNameToIngest, null);
        DocumentType originalCurrentDocType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        Assert.assertNotNull((String)("Should have found document for doc type '" + documentTypeName + "'"), (Object)originalCurrentDocType);
        Assert.assertNotNull((String)"Doc Type should have previous doc type id", (Object)originalCurrentDocType.getPreviousVersionId());
        Assert.assertEquals((String)"Doc Type should be current", (Object)Boolean.TRUE, (Object)originalCurrentDocType.getCurrentInd());
        DocumentType previousDocType1 = KEWServiceLocator.getDocumentTypeService().findById(originalCurrentDocType.getPreviousVersionId());
        Assert.assertNotNull((String)("Should have found document for doc type '" + documentTypeName + "' and previous version " + originalCurrentDocType.getPreviousVersionId()), (Object)previousDocType1);
        Assert.assertNotNull((String)"Doc Type should have previous doc type id", (Object)previousDocType1.getPreviousVersionId());
        DocumentType firstDocType = KEWServiceLocator.getDocumentTypeService().findById(previousDocType1.getPreviousVersionId());
        Assert.assertNotNull((String)("Should have found document for doc type '" + documentTypeName + "' and previous version " + previousDocType1.getPreviousVersionId()), (Object)firstDocType);
        Assert.assertNull((String)"Doc type retrieved should have been first doc type", (Object)firstDocType.getPreviousVersionId());
        originalCurrentDocType.setCurrentInd(Boolean.FALSE);
        KEWServiceLocator.getDocumentTypeService().save(originalCurrentDocType);
        firstDocType.setCurrentInd(Boolean.TRUE);
        KEWServiceLocator.getDocumentTypeService().save(firstDocType);
        DocumentType newCurrentDocType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        Assert.assertNotNull((String)("Should have found document for doc type '" + documentTypeName + "'"), (Object)newCurrentDocType);
        Assert.assertEquals((String)"Version of new doc type should match that of first doc type", (Object)firstDocType.getVersion(), (Object)newCurrentDocType.getVersion());
        try {
            this.testDoc(fileNameToIngest, null);
        }
        catch (Exception e) {
            Assert.fail((String)("File should have ingested correctly" + e.getLocalizedMessage()));
        }
        DocumentType currentDocType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        Assert.assertNotNull((String)("Should have found document for doc type '" + documentTypeName + "'"), (Object)currentDocType);
        Assert.assertEquals((String)"Doc Type should be current", (Object)Boolean.TRUE, (Object)currentDocType.getCurrentInd());
        Assert.assertNotNull((String)"Doc Type should have previous doc type id", (Object)currentDocType.getPreviousVersionId());
        Assert.assertEquals((String)"New current document should have version 1 greater than ", (Object)(originalCurrentDocType.getVersion() + 1), (Object)currentDocType.getVersion());
        previousDocType1 = KEWServiceLocator.getDocumentTypeService().findById(currentDocType.getPreviousVersionId());
        Assert.assertNotNull((String)("Should have found document for doc type '" + documentTypeName + "' and previous version " + newCurrentDocType.getPreviousVersionId()), (Object)previousDocType1);
        Assert.assertFalse((String)"Doc Type should be current", (boolean)previousDocType1.getCurrentInd());
        Assert.assertNull((String)"Doc type retrieved should not have previous doc type", (Object)previousDocType1.getPreviousVersionId());
    }

    @Test
    public void testLoadDocWithOrderedAttributes() throws Exception {
        List<DocumentType> documentTypes = this.testDoc("ValidActivationTypes", null);
        Assert.assertEquals((String)"Should only be one doc type parsed", (long)1L, (long)documentTypes.size());
        DocumentType docType = documentTypes.get(0);
        for (int i = 0; i < docType.getDocumentTypeAttributes().size(); ++i) {
            DocumentTypeAttributeBo attribute = (DocumentTypeAttributeBo)docType.getDocumentTypeAttributes().get(i);
            Assert.assertEquals((String)"Invalid Index Number", (long)(i + 1), (long)attribute.getOrderIndex());
        }
        DocumentType docTypeFresh = KEWServiceLocator.getDocumentTypeService().findByName("DocumentTypeXmlParserTestDoc_ValidActivationTypes");
        Assert.assertEquals((String)"Should be 3 doc type attributes", (long)3L, (long)docTypeFresh.getDocumentTypeAttributes().size());
        int index = 0;
        DocumentTypeAttributeBo attribute = (DocumentTypeAttributeBo)docTypeFresh.getDocumentTypeAttributes().get(index);
        Assert.assertEquals((String)"Invalid Index Number", (long)(index + 1), (long)attribute.getOrderIndex());
        Assert.assertEquals((String)("Invalid attribute name for order value " + index + 1), (Object)"TestRuleAttribute2", (Object)attribute.getRuleAttribute().getName());
        index = 1;
        attribute = (DocumentTypeAttributeBo)docTypeFresh.getDocumentTypeAttributes().get(index);
        Assert.assertEquals((String)"Invalid Index Number", (long)(index + 1), (long)attribute.getOrderIndex());
        Assert.assertEquals((String)("Invalid attribute name for order value " + index + 1), (Object)"TestRuleAttribute3", (Object)attribute.getRuleAttribute().getName());
        index = 2;
        attribute = (DocumentTypeAttributeBo)docTypeFresh.getDocumentTypeAttributes().get(index);
        Assert.assertEquals((String)"Invalid Index Number", (long)(index + 1), (long)attribute.getOrderIndex());
        Assert.assertEquals((String)("Invalid attribute name for order value " + index + 1), (Object)"TestRuleAttribute", (Object)attribute.getRuleAttribute().getName());
    }

    @Test
    public void testLoadDocWithNoLabel() throws Exception {
        List<DocumentType> documentTypes = this.testDoc("DocTypeWithNoLabel", false, null);
        Assert.assertEquals((String)"Should have parsed 1 document type", (long)1L, (long)documentTypes.size());
        DocumentType documentType = documentTypes.get(0);
        Assert.assertEquals((String)"Document type has incorrect name", (Object)"DocumentTypeXmlParserTestDoc_DocTypeWithNoLabel", (Object)documentType.getName());
        Assert.assertEquals((String)"Document type has incorrect label", (Object)"Undefined", (Object)documentType.getLabel());
        DocumentType testDocType3 = KEWServiceLocator.getDocumentTypeService().findByName("TestDocumentType3");
        Assert.assertNotNull((String)"TestDocumentType3 should exist.", (Object)testDocType3);
        String expectedLabel = "TestDocumentType";
        Assert.assertEquals((String)"Incorrect label", (Object)expectedLabel, (Object)testDocType3.getLabel());
        documentTypes = this.testDoc("DocTypeWithNoLabelPreviousVersion", false, null);
        Assert.assertEquals((String)"Should have parsed 1 document type", (long)1L, (long)documentTypes.size());
        testDocType3 = documentTypes.get(0);
        Assert.assertEquals((String)"Document type has incorrect name", (Object)"TestDocumentType3", (Object)testDocType3.getName());
        Assert.assertEquals((String)"Document type has incorrect label", (Object)expectedLabel, (Object)testDocType3.getLabel());
    }

    @Test
    public void testLoadOverwriteModeDocumentType() throws Exception {
        String docTypeName = "LoadRoutePathOnlyAdjustsDocument";
        this.testDoc("RoutePathAdjustment1", null);
        DocumentType docType1 = KEWServiceLocator.getDocumentTypeService().findByName(docTypeName);
        Assert.assertNotNull((String)"Document type should exist", (Object)docType1);
        Assert.assertEquals((String)"The blanket approve workgroup name is incorrect", (Object)"TestWorkgroup", (Object)docType1.getBlanketApproveWorkgroup().getName());
        Assert.assertEquals((String)"The blanket approve workgroup namespace is incorrect", (Object)"KR-WKFLW", (Object)docType1.getBlanketApproveWorkgroup().getNamespaceCode());
        Assert.assertEquals((String)"The super user workgroup name is incorrect", (Object)"TestWorkgroup", (Object)docType1.getSuperUserWorkgroup().getName());
        Assert.assertEquals((String)"The super user workgroup namespace is incorrect", (Object)"KR-WKFLW", (Object)docType1.getSuperUserWorkgroup().getNamespaceCode());
        List routeNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(docType1, true);
        Assert.assertEquals((String)"Incorrect document route node count", (long)1L, (long)routeNodes.size());
        Assert.assertEquals((String)"Expected Route Node Name is incorrect", (Object)"First", (Object)((RouteNode)routeNodes.get(0)).getRouteNodeName());
        this.testDoc("RoutePathAdjustment2", null);
        DocumentType docType2 = KEWServiceLocator.getDocumentTypeService().findByName(docTypeName);
        Assert.assertNotNull((String)"Document type should exist", (Object)docType1);
        Assert.assertEquals((String)"The blanket approve workgroup name is incorrect", (Object)"WorkflowAdmin", (Object)docType2.getBlanketApproveWorkgroup().getName());
        Assert.assertEquals((String)"The blanket approve workgroup namespace is incorrect", (Object)"KR-WKFLW", (Object)docType2.getBlanketApproveWorkgroup().getNamespaceCode());
        Assert.assertEquals((String)"The super user workgroup name is incorrect", (Object)"TestWorkgroup", (Object)docType2.getSuperUserWorkgroup().getName());
        Assert.assertEquals((String)"The super user workgroup namespace is incorrect", (Object)"KR-WKFLW", (Object)docType2.getSuperUserWorkgroup().getNamespaceCode());
        routeNodes = KEWServiceLocator.getRouteNodeService().getFlattenedNodes(docType2, true);
        Assert.assertEquals((String)"Incorrect document route node count", (long)2L, (long)routeNodes.size());
        Assert.assertEquals((String)"Expected Route Node Name is incorrect", (Object)"First", (Object)((RouteNode)routeNodes.get(0)).getRouteNodeName());
        Assert.assertEquals((String)"Expected Route Node Name is incorrect", (Object)"Second", (Object)((RouteNode)routeNodes.get(1)).getRouteNodeName());
    }

    @Test
    public void testLoadDocWithOneChildPrecedingParent() throws Exception {
        List<DocumentType> docTypeList = this.testDoc("ChildParentTestConfig1_Reordered", null);
        Assert.assertEquals((String)"There should be 5 document types.", (long)5L, (long)docTypeList.size());
    }

    @Test
    public void testRouteDocWithOneChildPrecedingParent() throws Exception {
        this.loadXmlFile("ChildParentTestConfig1_Reordered.xml");
        List<DocumentType> docTypeList = this.testDoc("ChildParentTestConfig1_Routing", null);
        Assert.assertEquals((String)"There should be 5 document types.", (long)5L, (long)docTypeList.size());
    }

    @Test
    public void testLoadDocWithLargerChildPrecedenceInheritanceTree() throws Exception {
        List<DocumentType> docTypeList = this.testDoc("ChildParentTestConfig1_Reordered2", null);
        Assert.assertEquals((String)"There should be 10 document types.", (long)10L, (long)docTypeList.size());
    }

    @Test
    public void testRouteDocWithLargerChildPrecedenceInheritanceTree() throws Exception {
        this.loadXmlFile("ChildParentTestConfig1_Routing2_Prep.xml");
        List<DocumentType> docTypeList = this.testDoc("ChildParentTestConfig1_Routing2", null);
        Assert.assertEquals((String)"There should be 10 document types.", (long)10L, (long)docTypeList.size());
    }

    private void tryLoadingBadDocument(String docTypeFileName, String failToFailMessage) {
        try {
            this.loadXmlFile(docTypeFileName);
            Assert.fail((String)failToFailMessage);
        }
        catch (WorkflowRuntimeException workflowRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadBadDocWithAppDocStatus() throws Exception {
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <status>bogus1</status>\n        <category name=\"bogus1\">\n          <status>Completed</status>\n        </category>\n      </validApplicationStatuses>", "duplicate category and status name should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <category name=\"bogus1\">\n          <status>Approved</status>\n        </category>\n        <category name=\"bogus1\">\n          <status>Completed</status>\n        </category>\n      </validApplicationStatuses>", "duplicate category name should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <category name=\"\">\n          <status>Approved</status>\n        </category>\n      </validApplicationStatuses>", "empty category name should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <category>\n          <status>Approved</status>\n        </category>\n      </validApplicationStatuses>", "no category name should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <status>bogus1</status>\n        <category name=\"IN PROGRESS\">\n        </category>\n      </validApplicationStatuses>", "empty category should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <status>bogus1</status>\n        <status>bogus1</status>\n      </validApplicationStatuses>", "duplicate status name should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <status></status>\n      </validApplicationStatuses>", "empty status content should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <status/>\n      </validApplicationStatuses>", "no status content should cause failure to ingest");
        this.loadDocWithBadAppDocStatus("      <validApplicationStatuses>\n        <status/>\n      </validApplicationStatuses>", "no status content should cause failure to ingest");
    }

    private void loadDocWithBadAppDocStatus(String validAppStatusesContent, String failureMessage) {
        try {
            String docTypeContent = applicationStatusDocumentTypeTemplate.replace("VALIDAPPSTATUSES", validAppStatusesContent);
            this.loadXmlStream(new ByteArrayInputStream(docTypeContent.getBytes()));
            Assert.fail((String)failureMessage);
        }
        catch (WorkflowRuntimeException workflowRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLoadDocWithAppDocStatus() throws Exception {
        this.loadXmlFile("TestKEWAppDocStatus.xml");
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("TestAppDocStatusDoc2");
        Assert.assertFalse((String)"DocumentStatusPolicy should not be set to KEW, or BOTH", (boolean)documentType.isKEWStatusInUse());
        Assert.assertTrue((String)"DocumentStatusPolicy should be set to APP", (boolean)documentType.isAppDocStatusInUse());
        Assert.assertTrue((String)"6 Valid Application Statuses should be defined", (documentType.getValidApplicationStatuses().size() == 6 ? 1 : 0) != 0);
        for (ApplicationDocumentStatus myStatus : documentType.getValidApplicationStatuses()) {
            String myStatusName = myStatus.getStatusName();
            Assert.assertTrue((String)("Valid Status value is incorrect: " + myStatusName), ("Approval In Progress".equalsIgnoreCase(myStatusName) || "Submitted".equalsIgnoreCase(myStatusName) || "Pending".equalsIgnoreCase(myStatusName) || "Completed".equalsIgnoreCase(myStatusName) || "Approved".equalsIgnoreCase(myStatusName) || "Rejected".equalsIgnoreCase(myStatusName) ? 1 : 0) != 0);
        }
        List procs = documentType.getProcesses();
        ProcessDefinitionBo myProc = (ProcessDefinitionBo)procs.get(0);
        RouteNode myNode = myProc.getInitialRouteNode();
        String nextDocStatus = myNode.getNextDocStatus();
        Assert.assertTrue((String)"RouteNode nextDocStatus is Invalid", (boolean)"Approval in Progress".equalsIgnoreCase(nextDocStatus));
        DocumentType documentType4 = KEWServiceLocator.getDocumentTypeService().findByName("TestAppDocStatusDoc4");
        List categories = documentType4.getApplicationStatusCategories();
        Assert.assertTrue((2 == categories.size() ? 1 : 0) != 0);
        Assert.assertTrue((9 == documentType4.getValidApplicationStatuses().size() ? 1 : 0) != 0);
    }

    @Test
    public void testLoadDocWithInvalidDocumentStatusPolicy() throws Exception {
        this.testDoc("DocumentStatusPolicyInvalidStringValue", XmlException.class);
    }

    @Test
    public void testLoadDocWithBlankDocumentStatusPolicyStringValue() throws Exception {
        this.testDoc("DocumentStatusPolicyMissingStringValue", false, XmlException.class);
    }

    @Test
    public void testLoadDocWithDocTypePolicyXMLConfig() throws Exception {
        List<DocumentType> docTypes = this.testDoc("DocumentTypePolicyConfig", null);
        Assert.assertEquals((long)1L, (long)docTypes.size());
        DocumentType docType = docTypes.get(0);
        DocumentTypePolicy policy = docType.getRecallNotification();
        Assert.assertNotNull((Object)policy);
        Assert.assertNotNull((Object)policy.getPolicyStringValue());
        Assert.assertEquals((Object)"<config><recipients xmlns:r=\"ns:workflow/Rule\" xsi:schemaLocation=\"ns:workflow/Rule resource:Rule\"><r:principalName>quickstart</r:principalName><r:user>quickstart</r:user><role name=\"foobar\" namespace=\"KEW\"/></recipients></config>", (Object)policy.getPolicyStringValue().replaceAll("\\n*", ""));
    }

    private boolean isActionCodeValidForDocument(WorkflowDocument document, String actionCode) {
        return document.isValidAction(ActionType.fromCode((String)actionCode));
    }
}

