/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.api.exception;

/**
 * This class represents a dismissal exception - when notifications are not properly dismissed 
 * by a deliverer
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class MessageDismissalException extends MessageDeliveryProcessingException {
    /**
     * Constructs a NotificationMessageDismissalException instance.
     */
    public MessageDismissalException() {
        super();
    }

    /**
     * Constructs a NotificationMessageDismissalException instance.
     * @param message
     * @param cause
     */
    public MessageDismissalException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a NotificationMessageDismissalException instance.
     * @param message
     */
    public MessageDismissalException(String message) {
        super(message);
    }

    /**
     * Constructs a NotificationMessageDismissalException instance.
     * @param cause
     */
    public MessageDismissalException(Throwable cause) {
        super(cause);
    }
}
