/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import java.util.List;

import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.mo.common.Identifiable;

public interface ActionRequestContract extends Identifiable {

	@Override
    String getId();
	
	ActionRequestType getActionRequested();
	
	ActionRequestStatus getStatus();
	
	boolean isCurrent();
	
	DateTime getDateCreated();
	
	String getResponsibilityId();
	
	String getDocumentId();
		
	int getPriority();

    int getRouteLevel();
	
	String getAnnotation();
		
	RecipientType getRecipientType();
	
	String getPrincipalId();
	
	String getGroupId();
	
	ActionRequestPolicy getRequestPolicy();
	
	String getResponsibilityDescription();
	
	boolean isForceAction();
	
	DelegationType getDelegationType();
	
	String getRoleName();
	
	String getQualifiedRoleName();
	
	String getQualifiedRoleNameLabel();
	
	String getRouteNodeInstanceId();
	
	String getNodeName();
	
	String getRequestLabel();
	
	String getParentActionRequestId();
	
	ActionTakenContract getActionTaken();
	
	List<? extends ActionRequestContract> getChildRequests();
		
}
