/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.preferences;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

import org.kuali.rice.kew.api.KewApiConstants;

/**
 * A service which provides data access for {@link Preferences}.
 *
 * @see Preferences
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@WebService(name = "preferencesService", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface PreferencesService {

    @WebMethod(operationName = "savePreferences")
    public void savePreferences(@WebParam(name="principalId") String principalId, @WebParam(name="preferences") Preferences actionListPreferences);

    @WebMethod(operationName = "getPreferences")
    @WebResult(name = "preferences")
    //@Cacheable(value= Preferences.Cache.NAME, key="'principalId=' + #principalId")
    public Preferences getPreferences(@WebParam(name="principalId") String principalId);
}
