/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.rule;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;

import java.util.Map;

public interface RuleTemplateAttributeContract extends Identifiable, Versioned, GloballyUnique, Inactivatable {
	String getRuleTemplateId();
	boolean isRequired();
	Integer getDisplayOrder();
	String getDefaultValue();

	ExtensionDefinitionContract getRuleAttribute();
	Map<String, String> getRuleExtensionMap();
}
