/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.extension;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiConstants;
import org.springframework.cache.annotation.Cacheable;

import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import java.util.List;


/**
 * A service which is used for retrieving information about extensions to various
 * pieces of Kuali Enterprise Workflow.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@WebService(name = "extensionRepositoryService", targetNamespace = KewApiConstants.Namespaces.KEW_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface ExtensionRepositoryService {
    /**
     * Returns the {@link ExtensionDefinition} of the RuleAttribute for the given id.
     * @param id the id to search by.
     * @return the extension definition found for the matching rule attribute service
     * @throws RiceIllegalArgumentException if id is null or blank
     */
    @WebMethod(operationName = "getExtensionById")
    @WebResult(name = "extensionDefinition")
    @Cacheable(value= ExtensionDefinition.Cache.NAME, key="'id=' + #p0")
    ExtensionDefinition getExtensionById(String id) throws RiceIllegalArgumentException;

    /**
     * Returns the {@link ExtensionDefinition} of the RuleAttribute for the given name.
     * @param name the name to search by.
     * @return the extension definition found for the matching rule attribute service
     * @throws RiceIllegalArgumentException if name is null or blank
     */
    @WebMethod(operationName = "getExtensionByName")
    @WebResult(name = "extensionDefinition")
    @Cacheable(value= ExtensionDefinition.Cache.NAME, key="'name=' + #p0")
    ExtensionDefinition getExtensionByName(String name) throws RiceIllegalArgumentException;

    /**
     * Returns the {@link ExtensionDefinition} of the {@link RuleAttribute} for the given resourceDescriptor.
     * @param resourceDescriptor the resourceDescriptor to search by.
     * @return the extension definition found for the matching rule attribute service
     * @throws RiceIllegalArgumentException if resourceDescriptor is null or blank
     */
    @WebMethod(operationName = "getExtensionByResourceDescriptor")
    @WebResult(name = "extensionDefinitions")
    @Cacheable(value=ExtensionDefinition.Cache.NAME, key="'resourceDescriptor=' + #p0")
    List<ExtensionDefinition> getExtensionsByResourceDescriptor(String resourceDescriptor) throws RiceIllegalArgumentException;

}
