/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.document.security;

import org.kuali.rice.kew.api.document.Document;

import java.io.Serializable;

/**
 * This is an attribute used to implement custom document security for document search and the route log.
 * SecurityAttributes are configured to be associated with the document type against which they should
 * be applied.  For each route log or row that is returned from a document search, this authorization
 * methods will be executed. 
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface DocumentSecurityAttribute extends Serializable {

    /**
     * Determines whether or not a principal is authorized to see information about a given document.
     *
     * @param principalId the principalId for which to check authorization
     * @param document the document for which to check security
     *
     * @return true if the principal is authorized to view the document, false otherwise
     */
    boolean isAuthorizedForDocument(String principalId, Document document);

}
