/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

import org.kuali.rice.kew.api.action.ActionTaken;

/**
 * Event sent to the postprocessor when an action has been taken
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActionTakenEvent implements IDocumentEvent {

	private static final long serialVersionUID = 2945081851810845704L;
	private String documentId;
	private String appDocId;
	private ActionTaken actionTaken;

	public ActionTakenEvent(String documentId, String appDocId, ActionTaken actionTaken) {
		this.documentId = documentId;
		this.appDocId = appDocId;
		this.actionTaken = actionTaken;
	}

	@Override
    public String getDocumentEventCode() {
		return ACTION_TAKEN;
	}

	@Override
    public String getDocumentId() {
		return documentId;
	}

	public ActionTaken getActionTaken() {
		return actionTaken;
	}

	@Override
    public String getAppDocId() {
		return appDocId;
	}

}
