/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

import org.kuali.rice.kew.framework.postprocessor.IDocumentEvent;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 * Signal to the PostProcessor that the routeHeader is being deleted.
 * 
 */
public class DeleteEvent implements IDocumentEvent {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1991987156524201870L;

	private String appDocId;

	private String documentId;

	public DeleteEvent(String documentId, String appDocId) {
		this.documentId = documentId;
		this.appDocId = appDocId;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.kuali.rice.kew.IDocumentEvent#getDocumentEventCode()
	 */
	@Override
    public String getDocumentEventCode() {
		return DELETE_CHANGE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.kuali.rice.kew.IDocumentEvent#getDocumentId()
	 */
	@Override
    public String getDocumentId() {
		return documentId;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.kuali.rice.kew.IDocumentEvent#getAppDocId()
	 */
	@Override
    public String getAppDocId() {
		return this.appDocId;
	}
}
