/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.template;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.common.template.TemplateContract;
import org.w3c.dom.Element;

@XmlRootElement(name="template")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="TemplateType", propOrder={"id", "namespaceCode", "name", "description", "kimTypeId", "active", "versionNumber", "objectId", "_futureElements"})
public final class Template
extends AbstractDataTransferObject
implements TemplateContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="kimTypeId", required=true)
    private final String kimTypeId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Template() {
        this.id = null;
        this.namespaceCode = null;
        this.name = null;
        this.description = null;
        this.kimTypeId = null;
        this.active = false;
        this.versionNumber = 1L;
        this.objectId = null;
    }

    private Template(Builder builder) {
        this.id = builder.getId();
        this.namespaceCode = builder.getNamespaceCode();
        this.name = builder.getName();
        this.description = builder.getDescription();
        this.kimTypeId = builder.getKimTypeId();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static final class Builder
    implements TemplateContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String namespaceCode;
        private String name;
        private String description;
        private String kimTypeId;
        private Long versionNumber = 1L;
        private String objectId;
        private boolean active;

        private Builder(String namespaceCode, String name, String kimTypeId) {
            this.setNamespaceCode(namespaceCode);
            this.setName(name);
            this.setKimTypeId(kimTypeId);
        }

        public static Builder create(String namespaceCode, String name, String kimTypeId) {
            return new Builder(namespaceCode, name, kimTypeId);
        }

        public static Builder create(TemplateContract contract) {
            Builder builder = new Builder(contract.getNamespaceCode(), contract.getName(), contract.getKimTypeId());
            builder.setId(contract.getId());
            builder.setDescription(contract.getDescription());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isEmpty((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode is blank");
            }
            this.namespaceCode = namespaceCode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (StringUtils.isEmpty((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String getKimTypeId() {
            if (StringUtils.isEmpty((String)this.kimTypeId)) {
                throw new IllegalArgumentException("kimTypeId is blank");
            }
            return this.kimTypeId;
        }

        public void setKimTypeId(String kimTypeId) {
            this.kimTypeId = kimTypeId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            if (versionNumber <= 0L) {
                throw new IllegalArgumentException("versionNumber is invalid");
            }
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public Template build() {
            return new Template(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/TemplateType";
    }

    static class Elements {
        static final String ID = "id";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String KIM_TYPE_ID = "kimTypeId";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "template";
        static final String TYPE_NAME = "TemplateType";

        Constants() {
        }
    }
}

