/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.email;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.Element;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;

@XmlRootElement(name="entityEmail")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityEmailType", propOrder={"id", "entityTypeCode", "entityId", "emailType", "emailAddress", "emailAddressUnmasked", "suppressEmail", "defaultValue", "active", "versionNumber", "objectId", "_futureElements"})
public class EntityEmail
extends AbstractDataTransferObject
implements EntityEmailContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="entityTypeCode", required=false)
    private final String entityTypeCode;
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="emailType", required=false)
    private final CodedAttribute emailType;
    @XmlElement(name="emailAddress", required=false)
    private final String emailAddress;
    @XmlElement(name="emailAddressUnmasked", required=false)
    private final String emailAddressUnmasked;
    @XmlElement(name="suppressEmail", required=false)
    private final boolean suppressEmail;
    @XmlElement(name="defaultValue", required=false)
    private final boolean defaultValue;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityEmail() {
        this.id = null;
        this.entityId = null;
        this.entityTypeCode = null;
        this.emailType = null;
        this.emailAddress = null;
        this.emailAddressUnmasked = null;
        this.suppressEmail = false;
        this.defaultValue = false;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
    }

    private EntityEmail(Builder builder) {
        this.id = builder.getId();
        this.entityId = builder.getEntityId();
        this.entityTypeCode = builder.getEntityTypeCode();
        this.emailType = builder.getEmailType() != null ? builder.getEmailType().build() : null;
        this.emailAddress = builder.getEmailAddress();
        this.emailAddressUnmasked = builder.getEmailAddressUnmasked();
        this.suppressEmail = builder.isSuppressEmail();
        this.defaultValue = builder.isDefaultValue();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    @Override
    public CodedAttribute getEmailType() {
        return this.emailType;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public String getEmailAddressUnmasked() {
        return this.emailAddressUnmasked;
    }

    @Override
    public boolean isSuppressEmail() {
        return this.suppressEmail;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityEmailContract {
        private String id;
        private String entityId;
        private String entityTypeCode;
        private CodedAttribute.Builder emailType;
        private String emailAddressUnmasked;
        private boolean suppressEmail;
        private boolean defaultValue;
        private Long versionNumber;
        private String objectId;
        private boolean active;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityEmailContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setId(contract.getId());
            builder.setEntityId(contract.getEntityId());
            builder.setEntityTypeCode(contract.getEntityTypeCode());
            builder.setSuppressEmail(contract.isSuppressEmail());
            if (contract.getEmailType() != null) {
                builder.setEmailType(CodedAttribute.Builder.create(contract.getEmailType()));
            }
            builder.setEmailAddress(contract.getEmailAddressUnmasked());
            builder.setDefaultValue(contract.isDefaultValue());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            return builder;
        }

        public EntityEmail build() {
            return new EntityEmail(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getEntityTypeCode() {
            return this.entityTypeCode;
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public CodedAttribute.Builder getEmailType() {
            return this.emailType;
        }

        @Override
        public String getEmailAddress() {
            if (this.isSuppressEmail()) {
                return "Xxxxxx";
            }
            return this.emailAddressUnmasked;
        }

        @Override
        public String getEmailAddressUnmasked() {
            return this.emailAddressUnmasked;
        }

        @Override
        public boolean isSuppressEmail() {
            return this.suppressEmail;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        public void setEntityTypeCode(String entityTypeCode) {
            this.entityTypeCode = entityTypeCode;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setEmailType(CodedAttribute.Builder emailType) {
            this.emailType = emailType;
        }

        public void setEmailAddress(String emailAddress) {
            this.emailAddressUnmasked = emailAddress;
        }

        private void setSuppressEmail(boolean suppressEmail) {
            this.suppressEmail = suppressEmail;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String ENTITY_TYPE_CODE = "entityTypeCode";
        static final String ENTITY_ID = "entityId";
        static final String EMAIL_TYPE = "emailType";
        static final String EMAIL_ADDRESS = "emailAddress";
        static final String EMAIL_ADDRESS_UNMASKED = "emailAddressUnmasked";
        static final String SUPPRESS_EMAIL = "suppressEmail";
        static final String DEFAULT_VALUE = "defaultValue";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityEmail";
        static final String TYPE_NAME = "EntityEmailType";

        Constants() {
        }
    }
}

