/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity;

import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.entity.EntityDefaultQueryResults;
import org.kuali.rice.kim.api.identity.entity.EntityQueryResults;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierType;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographics;
import org.kuali.rice.kim.api.identity.personal.EntityEthnicity;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalQueryResults;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.identity.residency.EntityResidency;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.visa.EntityVisa;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="identityService", targetNamespace="http://rice.kuali.org/kim/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface IdentityService {
    @WebMethod(operationName="findEntityDefaults")
    @WebResult(name="results")
    public EntityDefaultQueryResults findEntityDefaults(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findEntities")
    @WebResult(name="results")
    public EntityQueryResults findEntities(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntity")
    @WebResult(name="entity")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityType"}, key="'id=' + #p0")
    public Entity getEntity(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntityByPrincipalId")
    @WebResult(name="entity")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityType"}, key="'principalId=' + #p0")
    public Entity getEntityByPrincipalId(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntityByPrincipalName")
    @WebResult(name="entity")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityType"}, key="'principalName=' + #p0")
    public Entity getEntityByPrincipalName(@WebParam(name="principalName") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntityByEmployeeId")
    @WebResult(name="entity")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityType"}, key="'employeeId=' + #p0")
    public Entity getEntityByEmployeeId(@WebParam(name="employeeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createEntity")
    @WebResult(name="entity")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public Entity createEntity(@WebParam(name="entity") Entity var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateEntity")
    @WebResult(name="entity")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType", "http://rice.kuali.org/kim/v2_0/EntityNamePrincipalNameType"}, allEntries=true)
    public Entity updateEntity(@WebParam(name="entity") Entity var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateEntity")
    @WebResult(name="entity")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public Entity inactivateEntity(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getEntityDefault")
    @WebResult(name="entityDefault")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, key="'id=' + #p0")
    public EntityDefault getEntityDefault(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntityDefaultByPrincipalId")
    @WebResult(name="entityDefault")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, key="'principalId=' + #p0")
    public EntityDefault getEntityDefaultByPrincipalId(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntityDefaultByPrincipalName")
    @WebResult(name="entityDefault")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, key="'principalName=' + #p0")
    public EntityDefault getEntityDefaultByPrincipalName(@WebParam(name="principalName") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getEntityDefaultByEmployeeId")
    @WebResult(name="entityDefault")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, key="'employeeId=' + #p0")
    public EntityDefault getEntityDefaultByEmployeeId(@WebParam(name="employeeId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPrincipal")
    @WebResult(name="principal")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PrincipalType"}, key="'principalId=' + #p0")
    public Principal getPrincipal(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPrincipals")
    @WebResult(name="ret")
    public List<Principal> getPrincipals(@WebParam(name="principalIds") List<String> var1);

    @WebMethod(operationName="getPrincipalsByEntityId")
    @WebResult(name="principals")
    public List<Principal> getPrincipalsByEntityId(@WebParam(name="entityId") String var1);

    @WebMethod(operationName="getPrincipalsByEmployeeId")
    @WebResult(name="principals")
    public List<Principal> getPrincipalsByEmployeeId(@WebParam(name="employeeId") String var1);

    @WebMethod(operationName="getPrincipalByPrincipalName")
    @WebResult(name="principal")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PrincipalType"}, key="'principalName=' + #p0")
    public Principal getPrincipalByPrincipalName(@WebParam(name="principalName") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPrincipalByPrincipalNameAndPassword")
    @WebResult(name="principal")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PrincipalType"}, key="'principalName=' + #p0 + '|' + 'password=' + #p1")
    public Principal getPrincipalByPrincipalNameAndPassword(@WebParam(name="principalName") String var1, @WebParam(name="password") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="addPrincipalToEntity")
    @WebResult(name="principal")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PrincipalType", "http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public Principal addPrincipalToEntity(@WebParam(name="principal") Principal var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updatePrincipal")
    @WebResult(name="principal")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PrincipalType", "http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType", "http://rice.kuali.org/kim/v2_0/EntityNamePrincipalNameType"}, allEntries=true)
    public Principal updatePrincipal(@WebParam(name="principal") Principal var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivatePrincipal")
    @WebResult(name="principal")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PrincipalType", "http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public Principal inactivatePrincipal(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivatePrincipalByName")
    @WebResult(name="principal")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PrincipalType", "http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public Principal inactivatePrincipalByName(@WebParam(name="principalName") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addEntityTypeContactInfoToEntity")
    @WebResult(name="entityTypeContactInfo")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityTypeContactInfo addEntityTypeContactInfoToEntity(@WebParam(name="entityTypeContactInfo") EntityTypeContactInfo var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateEntityTypeContactInfo")
    @WebResult(name="entityTypeContactInfo")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityTypeContactInfo updateEntityTypeContactInfo(@WebParam(name="entityTypeContactInfo") EntityTypeContactInfo var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateEntityTypeContactInfo")
    @WebResult(name="entityTypeContactInfo")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityTypeContactInfo inactivateEntityTypeContactInfo(@WebParam(name="entityId") String var1, @WebParam(name="entityTypeCode") String var2) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addAddressToEntity")
    @WebResult(name="address")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityAddress addAddressToEntity(@WebParam(name="address") EntityAddress var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateAddress")
    @WebResult(name="address")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityAddress updateAddress(@WebParam(name="address") EntityAddress var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateAddress")
    @WebResult(name="address")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityAddress inactivateAddress(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addEmailToEntity")
    @WebResult(name="email")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEmail addEmailToEntity(@WebParam(name="email") EntityEmail var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateEmail")
    @WebResult(name="email")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEmail updateEmail(@WebParam(name="email") EntityEmail var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateEmail")
    @WebResult(name="email")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEmail inactivateEmail(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addPhoneToEntity")
    @WebResult(name="phone")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityPhone addPhoneToEntity(@WebParam(name="phone") EntityPhone var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updatePhone")
    @WebResult(name="phone")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityPhone updatePhone(@WebParam(name="phone") EntityPhone var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivatePhone")
    @WebResult(name="phone")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityPhone inactivatePhone(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addExternalIdentifierToEntity")
    @WebResult(name="externalId")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityExternalIdentifier addExternalIdentifierToEntity(@WebParam(name="externalId") EntityExternalIdentifier var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateExternalIdentifier")
    @WebResult(name="externalId")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityExternalIdentifier updateExternalIdentifier(@WebParam(name="externalId") EntityExternalIdentifier var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addAffiliationToEntity")
    @WebResult(name="affiliation")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityAffiliation addAffiliationToEntity(@WebParam(name="affiliation") EntityAffiliation var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateAffiliation")
    @WebResult(name="affiliation")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityAffiliation updateAffiliation(@WebParam(name="affiliation") EntityAffiliation var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateAffiliation")
    @WebResult(name="affiliation")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityAffiliation inactivateAffiliation(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getDefaultNamesForPrincipalId")
    @WebResult(name="entityNamePrincipalName")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityNamePrincipalNameType"}, key="'principalId=' + #p0")
    public EntityNamePrincipalName getDefaultNamesForPrincipalId(@WebParam(name="principalId") String var1);

    @WebMethod(operationName="getDefaultNamesForPrincipalIds")
    @WebResult(name="entityNamePrincipalNames")
    public Map<String, EntityNamePrincipalName> getDefaultNamesForPrincipalIds(@WebParam(name="principalIds") List<String> var1);

    @WebMethod(operationName="getPrivacyPreferencesForPrincipalId")
    @WebResult(name="entityPrivacyPreferences")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityPrivacyPreferencesType"}, key="'principalId=' + #p0")
    public EntityPrivacyPreferences getPrivacyPreferencesForPrincipalId(@WebParam(name="principalId") String var1);

    @WebMethod(operationName="addNameToEntity")
    @WebResult(name="name")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType", "http://rice.kuali.org/kim/v2_0/EntityNamePrincipalNameType"}, allEntries=true)
    public EntityName addNameToEntity(@WebParam(name="name") EntityName var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateName")
    @WebResult(name="name")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType", "http://rice.kuali.org/kim/v2_0/EntityNamePrincipalNameType"}, allEntries=true)
    public EntityName updateName(@WebParam(name="name") EntityName var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateName")
    @WebResult(name="name")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityName inactivateName(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addEmploymentToEntity")
    @WebResult(name="employment")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEmployment addEmploymentToEntity(@WebParam(name="employment") EntityEmployment var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateEmployment")
    @WebResult(name="employment")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEmployment updateEmployment(@WebParam(name="employment") EntityEmployment var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateEmployment")
    @WebResult(name="employment")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEmployment inactivateEmployment(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addBioDemographicsToEntity")
    @WebResult(name="bioDemographics")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityBioDemographics addBioDemographicsToEntity(@WebParam(name="bioDemographics") EntityBioDemographics var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateBioDemographics")
    @WebResult(name="bioDemographics")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityBioDemographics updateBioDemographics(@WebParam(name="bioDemographics") EntityBioDemographics var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getEntityPrivacyPreferences")
    @WebResult(name="privacyPreferences")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/EntityPrivacyPreferencesType"}, key="'id=' + #p0")
    public EntityPrivacyPreferences getEntityPrivacyPreferences(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="addPrivacyPreferencesToEntity")
    @WebResult(name="privacyPreferences")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType", "http://rice.kuali.org/kim/v2_0/EntityPrivacyPreferencesType"}, allEntries=true)
    public EntityPrivacyPreferences addPrivacyPreferencesToEntity(@WebParam(name="privacyPreferences") EntityPrivacyPreferences var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updatePrivacyPreferences")
    @WebResult(name="privacyPreferences")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType", "http://rice.kuali.org/kim/v2_0/EntityPrivacyPreferencesType"}, allEntries=true)
    public EntityPrivacyPreferences updatePrivacyPreferences(@WebParam(name="privacyPreferences") EntityPrivacyPreferences var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addCitizenshipToEntity")
    @WebResult(name="citizenship")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityCitizenship addCitizenshipToEntity(@WebParam(name="citizenship") EntityCitizenship var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateCitizenship")
    @WebResult(name="citizenship")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityCitizenship updateCitizenship(@WebParam(name="citizenship") EntityCitizenship var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="inactivateCitizenship")
    @WebResult(name="citizenship")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityCitizenship inactivateCitizenship(@WebParam(name="id") String var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addEthnicityToEntity")
    @WebResult(name="ethnicity")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEthnicity addEthnicityToEntity(@WebParam(name="ethnicity") EntityEthnicity var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateEthnicity")
    @WebResult(name="ethnicity")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityEthnicity updateEthnicity(@WebParam(name="ethnicity") EntityEthnicity var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addResidencyToEntity")
    @WebResult(name="residency")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityResidency addResidencyToEntity(@WebParam(name="residency") EntityResidency var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateResidency")
    @WebResult(name="residency")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityResidency updateResidency(@WebParam(name="residency") EntityResidency var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="addVisaToEntity")
    @WebResult(name="visa")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityVisa addVisaToEntity(@WebParam(name="visa") EntityVisa var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateVisa")
    @WebResult(name="visa")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/EntityType", "http://rice.kuali.org/kim/v2_0/EntityDefaultType"}, allEntries=true)
    public EntityVisa updateVisa(@WebParam(name="visa") EntityVisa var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getEntityType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EntityType}"}, key="'code=' + #p0")
    public CodedAttribute getEntityType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllEntityTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EntityType}"}, key="'all'")
    public List<CodedAttribute> findAllEntityTypes();

    @WebMethod(operationName="getAddressType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{AddressType}"}, key="'code=' + #p0")
    public CodedAttribute getAddressType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllAddressTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{AddressType}"}, key="'all'")
    public List<CodedAttribute> findAllAddressTypes();

    @WebMethod(operationName="getAffiliationType")
    @WebResult(name="affiliationType")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{AffiliationType}"}, key="'code=' + #p0")
    public EntityAffiliationType getAffiliationType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllAffiliationTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{AffiliationType}"}, key="'all'")
    public List<EntityAffiliationType> findAllAffiliationTypes();

    @WebMethod(operationName="getCitizenshipStatus")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{CitizenshipStatus}"}, key="'code=' + #p0")
    public CodedAttribute getCitizenshipStatus(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllCitizenshipStatuses")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{CitizenshipStatus}"}, key="'all'")
    public List<CodedAttribute> findAllCitizenshipStatuses();

    @WebMethod(operationName="getEmploymentType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EmploymentType}"}, key="'code=' + #p0")
    public CodedAttribute getEmploymentType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllEmploymentTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EmploymentType}"}, key="'all'")
    public List<CodedAttribute> findAllEmploymentTypes();

    @WebMethod(operationName="getEmploymentStatus")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EmploymentStatus}"}, key="'code=' + #p0")
    public CodedAttribute getEmploymentStatus(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllEmploymentStatuses")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EmploymentStatus}"}, key="'all'")
    public List<CodedAttribute> findAllEmploymentStatuses();

    @WebMethod(operationName="getExternalIdentifierType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{ExternalIdentifierType}"}, key="'code=' + #p0")
    public EntityExternalIdentifierType getExternalIdentifierType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllExternalIdentifierTypeTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{ExternalIdentifierType}"}, key="'all'")
    public List<EntityExternalIdentifierType> findAllExternalIdendtifierTypes();

    @WebMethod(operationName="getNameType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{NameType}"}, key="'code=' + #p0")
    public CodedAttribute getNameType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllNameTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{NameType}"}, key="'all'")
    public List<CodedAttribute> findAllNameTypes();

    @WebMethod(operationName="getPhoneType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{PhoneType}"}, key="'code=' + #p0")
    public CodedAttribute getPhoneType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllPhoneTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{PhoneType}"}, key="'all'")
    public List<CodedAttribute> findAllPhoneTypes();

    @WebMethod(operationName="getEmailType")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EmailType}"}, key="'code=' + #p0")
    public CodedAttribute getEmailType(@WebParam(name="code") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllEmailTypes")
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/CodedAttributeType{EmailType}"}, key="'all'")
    public List<CodedAttribute> findAllEmailTypes();

    @WebMethod(operationName="findPrincipals")
    @WebResult(name="results")
    public PrincipalQueryResults findPrincipals(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;
}

