/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.kuali.rice.kim.impl.data.DataIntegrityService;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class DataIntegrityServiceImpl
implements DataIntegrityService,
InitializingBean {
    private static final String DUPLICATE_DELEGATIONS = "select role_id, dlgn_typ_cd, kim_typ_id, count(*) cnt from krim_dlgn_t where actv_ind = 'Y' group by role_id, dlgn_typ_cd, kim_typ_id having cnt > 1";
    private static final String BAD_DELEGATION_MEMBERS = "select m.dlgn_mbr_id, m.role_mbr_id, rm.role_id, r.kim_typ_id, d.dlgn_id, d.role_id, d.dlgn_typ_cd from krim_dlgn_t d, krim_dlgn_mbr_t m, krim_role_mbr_t rm, krim_role_t r where d.actv_ind = 'Y' and d.dlgn_id=m.dlgn_id and m.role_mbr_id=rm.role_mbr_id and rm.role_id=r.role_id and d.role_id != rm.role_id";
    private static final String DUPLICATE_DELEGATION_IDS = "select dlgn_id from krim_dlgn_t where role_id = ? and dlgn_typ_cd = ? and kim_typ_id = ? and actv_ind = 'Y'";
    private static final String FIX_DUPLICATE_DELEGATION_ID = "update krim_dlgn_mbr_t set dlgn_id = ? where dlgn_id = ?";
    private static final String DELETE_DUPLICATE_DELEGATION = "delete from krim_dlgn_t where dlgn_id = ?";
    private static final String FIND_TARGET_DELEGATION = "select dlgn_id from krim_dlgn_t where role_id = ? and dlgn_typ_cd = ? and actv_ind = 'Y'";
    private static final String CREATE_DELEGATION = "insert into krim_dlgn_t (dlgn_id, obj_id, role_id, kim_typ_id, dlgn_typ_cd, ver_nbr, actv_ind) values (?, ?, ?, ?, ?, 1, 'Y')";
    private static final String FIX_BAD_DELEGATION_MEMBER = "update krim_dlgn_mbr_t set dlgn_id = ? where dlgn_mbr_id = ?";
    private DataSource dataSource;
    private JdbcTemplate template;

    public void afterPropertiesSet() throws Exception {
        this.template = new JdbcTemplate(this.dataSource);
    }

    @Override
    public List<String> checkIntegrity() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.reportDuplicateDelegations(this.findDuplicateDelegations()));
        messages.addAll(this.reportBadDelegationMembers(this.findBadDelegationMembers()));
        return messages;
    }

    private List<String> reportDuplicateDelegations(List<DuplicateRoleDelegation> duplicateRoleDelegations) {
        ArrayList<String> reports = new ArrayList<String>();
        for (DuplicateRoleDelegation duplicateRoleDelegation : duplicateRoleDelegations) {
            reports.add(duplicateRoleDelegation.report());
        }
        return reports;
    }

    private List<String> reportBadDelegationMembers(List<BadDelegationMember> badDelegationMembers) {
        ArrayList<String> reports = new ArrayList<String>();
        for (BadDelegationMember badDelegationMember : badDelegationMembers) {
            reports.add(badDelegationMember.report());
        }
        return reports;
    }

    @Override
    public List<String> repair() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.repairDuplicateDelegations());
        messages.addAll(this.repairBadDelegationMembers());
        return messages;
    }

    private List<String> repairDuplicateDelegations() {
        ArrayList<String> messages = new ArrayList<String>();
        List<DuplicateRoleDelegation> duplicateRoleDelegations = this.findDuplicateDelegations();
        for (DuplicateRoleDelegation duplicateRoleDelegation : duplicateRoleDelegations) {
            messages.add(this.repairDuplicateDelegation(duplicateRoleDelegation));
        }
        return messages;
    }

    private String repairDuplicateDelegation(DuplicateRoleDelegation duplicateRoleDelegation) {
        List delegationIds = this.template.query(DUPLICATE_DELEGATION_IDS, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet resultSet, int i) throws SQLException {
                return resultSet.getString(1);
            }
        }, new Object[]{duplicateRoleDelegation.roleId, duplicateRoleDelegation.delegationTypeCode, duplicateRoleDelegation.kimTypeId});
        String delegationIdToKeep = (String)delegationIds.remove(0);
        for (String delegationId : delegationIds) {
            this.template.update(FIX_DUPLICATE_DELEGATION_ID, new Object[]{delegationIdToKeep, delegationId});
            this.template.update(DELETE_DUPLICATE_DELEGATION, new Object[]{delegationId});
        }
        return this.reportRepairDuplicateDelegation(duplicateRoleDelegation, delegationIdToKeep, delegationIds);
    }

    private String reportRepairDuplicateDelegation(DuplicateRoleDelegation duplicateRoleDelegation, String delegationIdToKeep, List<String> duplicateDelegationIds) {
        StringBuilder message = new StringBuilder();
        message.append("Repaired duplicate delegations with roleId = ").append(duplicateRoleDelegation.roleId).append(", delegationTypeCode = ").append(duplicateRoleDelegation.delegationTypeCode).append(", and kimTypeId = ").append(duplicateRoleDelegation.kimTypeId).append(". Retained delegation with id ").append(delegationIdToKeep).append(". Deleted the following delegations and repointed their members to delegation id ").append(delegationIdToKeep).append(": [ ");
        for (String duplicateDelegationId : duplicateDelegationIds) {
            message.append(duplicateDelegationId).append(", ");
        }
        message.delete(message.length() - 2, message.length());
        message.append(" ]");
        return message.toString();
    }

    private List<String> repairBadDelegationMembers() {
        ArrayList<String> messages = new ArrayList<String>();
        List<BadDelegationMember> badDelegationMembers = this.findBadDelegationMembers();
        for (BadDelegationMember badDelegationMember : badDelegationMembers) {
            messages.add(this.repairBadDelegationMember(badDelegationMember));
        }
        return messages;
    }

    private String repairBadDelegationMember(BadDelegationMember badDelegationMember) {
        String targetDelegationId;
        List delegationIds = this.template.query(FIND_TARGET_DELEGATION, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet resultSet, int i) throws SQLException {
                return resultSet.getString(1);
            }
        }, new Object[]{badDelegationMember.roleMemberRoleId, badDelegationMember.delegationTypeCode});
        boolean newDelegationCreated = false;
        if (delegationIds.isEmpty()) {
            targetDelegationId = this.getNextDelegationId();
            String objectId = UUID.randomUUID().toString();
            this.template.update(CREATE_DELEGATION, new Object[]{targetDelegationId, objectId, badDelegationMember.roleMemberRoleId, badDelegationMember.roleMemberRoleKimTypeId, badDelegationMember.delegationTypeCode});
            newDelegationCreated = true;
        } else {
            targetDelegationId = (String)delegationIds.get(0);
        }
        this.template.update(FIX_BAD_DELEGATION_MEMBER, new Object[]{targetDelegationId, badDelegationMember.delegationMemberId});
        return this.reportRepairBadDelegationMember(badDelegationMember, targetDelegationId, newDelegationCreated);
    }

    private String reportRepairBadDelegationMember(BadDelegationMember badDelegationMember, String targetDelegationId, boolean newDelegationCreated) {
        StringBuilder message = new StringBuilder();
        message.append("Repaired bad delegation member ").append(badDelegationMember.toString());
        if (newDelegationCreated) {
            message.append(" New delegation created with id ").append(targetDelegationId).append(" since there was no existing delegation that matched for the proper role id and delegation type.");
        } else {
            message.append(" Reassigned the delegation member to an existing delegation with id ").append(targetDelegationId).append(" because it matched the proper role id and delegation type.");
        }
        return message.toString();
    }

    private String getNextDelegationId() {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.dataSource, (String)"KRIM_DLGN_ID_S");
        return incrementer.nextStringValue();
    }

    private List<DuplicateRoleDelegation> findDuplicateDelegations() {
        return this.template.query(DUPLICATE_DELEGATIONS, (RowMapper)new RowMapper<DuplicateRoleDelegation>(){

            public DuplicateRoleDelegation mapRow(ResultSet resultSet, int i) throws SQLException {
                return new DuplicateRoleDelegation(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4));
            }
        });
    }

    private List<BadDelegationMember> findBadDelegationMembers() {
        return this.template.query(BAD_DELEGATION_MEMBERS, (RowMapper)new RowMapper<BadDelegationMember>(){

            public BadDelegationMember mapRow(ResultSet resultSet, int i) throws SQLException {
                return new BadDelegationMember(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7));
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    class BadDelegationMember {
        final String delegationMemberId;
        final String roleMemberId;
        final String roleMemberRoleId;
        final String roleMemberRoleKimTypeId;
        final String delegationId;
        final String delegationRoleId;
        final String delegationTypeCode;

        BadDelegationMember(String delegationMemberId, String roleMemberId, String roleMemberRoleId, String roleMemberRoleKimTypeId, String delegationId, String delegationRoleId, String delegationTypeCode) {
            this.delegationMemberId = delegationMemberId;
            this.roleMemberId = roleMemberId;
            this.roleMemberRoleId = roleMemberRoleId;
            this.roleMemberRoleKimTypeId = roleMemberRoleKimTypeId;
            this.delegationId = delegationId;
            this.delegationRoleId = delegationRoleId;
            this.delegationTypeCode = delegationTypeCode;
        }

        String report() {
            return "Found bad delegation member " + this.toString();
        }

        public String toString() {
            return String.format("[delegationMemberId = %s, roleMemberId = %s, roleMemberRoleId = %s, roleMemberRoleKimTypeId = %s, delegationId = %s, delegationRoleId = %s, delegationTypeCode = %s]", this.delegationMemberId, this.roleMemberId, this.roleMemberRoleId, this.roleMemberRoleKimTypeId, this.delegationId, this.delegationRoleId, this.delegationTypeCode);
        }
    }

    class DuplicateRoleDelegation {
        final String roleId;
        final String delegationTypeCode;
        final String kimTypeId;
        final int numMatching;

        DuplicateRoleDelegation(String roleId, String delegationTypeCode, String kimTypeId, int numMatching) {
            this.roleId = roleId;
            this.delegationTypeCode = delegationTypeCode;
            this.kimTypeId = kimTypeId;
            this.numMatching = numMatching;
        }

        String report() {
            return "Found duplicate role delegation " + this.toString();
        }

        public String toString() {
            return String.format("[roleId = %s, delegationTypeCode = %s, kimTypeId = %s, num of matching delegations = %d]", this.roleId, this.delegationTypeCode, this.kimTypeId, this.numMatching);
        }
    }
}

