/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.permission;



import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.util.AutoPopulatingList;

//strange - hacky non-PBO
public class UberPermissionBo extends PermissionBo implements BusinessObject {

    private static final long serialVersionUID = 1L;

    private List<RoleBo> assignedToRoles = new AutoPopulatingList(RoleBo.class);
    private String assignedToRoleNamespaceForLookup;
    private String assignedToRoleNameForLookup;
    private RoleBo assignedToRole = new RoleBo();
    private String assignedToPrincipalNameForLookup;
    private Person assignedToPrincipal = new PersonImpl();
    private String assignedToGroupNamespaceForLookup;
    private String assignedToGroupNameForLookup;
    private GroupBo assignedToGroup = new GroupBo();
    private String attributeName;
    private String attributeValue;
    private String detailCriteria;

    public static UberPermissionBo from(PermissionBo bo) {
        if (bo == null) {
            return null;
        }
        Permission.Builder builder =  Permission.Builder.create(bo);
        return (UberPermissionBo) PermissionBo.from(builder.build());

    }
    public String getAssignedToRolesToDisplay() {
        StringBuffer assignedToRolesText = new StringBuffer();
        for (RoleBo roleImpl: assignedToRoles) {
            assignedToRolesText.append(roleImpl.getNamespaceCode().trim())
                    .append(" ")
                    .append(roleImpl.getName().trim())
                    .append(KimConstants.KimUIConstants.COMMA_SEPARATOR);
        }
        return StringUtils.chomp(assignedToRolesText.toString(), KimConstants.KimUIConstants.COMMA_SEPARATOR);
    }

    public List<RoleBo> getAssignedToRoles() {
        return assignedToRoles;
    }

    public void setAssignedToRoles(List<RoleBo> assignedToRoles) {
        this.assignedToRoles = assignedToRoles;
    }

    public String getAssignedToRoleNamespaceForLookup() {
        return assignedToRoleNamespaceForLookup;
    }

    public void setAssignedToRoleNamespaceForLookup(String assignedToRoleNamespaceForLookup) {
        this.assignedToRoleNamespaceForLookup = assignedToRoleNamespaceForLookup;
    }

    public String getAssignedToRoleNameForLookup() {
        return assignedToRoleNameForLookup;
    }

    public void setAssignedToRoleNameForLookup(String assignedToRoleNameForLookup) {
        this.assignedToRoleNameForLookup = assignedToRoleNameForLookup;
    }

    public RoleBo getAssignedToRole() {
        return assignedToRole;
    }

    public void setAssignedToRole(RoleBo assignedToRole) {
        this.assignedToRole = assignedToRole;
    }

    public String getAssignedToPrincipalNameForLookup() {
        return assignedToPrincipalNameForLookup;
    }

    public void setAssignedToPrincipalNameForLookup(String assignedToPrincipalNameForLookup) {
        this.assignedToPrincipalNameForLookup = assignedToPrincipalNameForLookup;
    }

    public Person getAssignedToPrincipal() {
        return assignedToPrincipal;
    }

    public void setAssignedToPrincipal(Person assignedToPrincipal) {
        this.assignedToPrincipal = assignedToPrincipal;
    }

    public String getAssignedToGroupNamespaceForLookup() {
        return assignedToGroupNamespaceForLookup;
    }

    public void setAssignedToGroupNamespaceForLookup(String assignedToGroupNamespaceForLookup) {
        this.assignedToGroupNamespaceForLookup = assignedToGroupNamespaceForLookup;
    }

    public String getAssignedToGroupNameForLookup() {
        return assignedToGroupNameForLookup;
    }

    public void setAssignedToGroupNameForLookup(String assignedToGroupNameForLookup) {
        this.assignedToGroupNameForLookup = assignedToGroupNameForLookup;
    }

    public GroupBo getAssignedToGroup() {
        return assignedToGroup;
    }

    public void setAssignedToGroup(GroupBo assignedToGroup) {
        this.assignedToGroup = assignedToGroup;
    }

    public String getAttributeName() {
        return attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeValue() {
        return attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getDetailCriteria() {
        return detailCriteria;
    }

    public void setDetailCriteria(String detailCriteria) {
        this.detailCriteria = detailCriteria;
    }

    @Override
    public void refresh() {
    }
}

