/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.platform;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.persistence.platform.ANSISqlDatabasePlatform;

public class OracleDatabasePlatform
extends ANSISqlDatabasePlatform {
    private static final Logger LOG = Logger.getLogger(OracleDatabasePlatform.class);
    private static final long DEFAULT_TIMEOUT_SECONDS = 3600L;
    public static final long WAIT_FOREVER = -1L;
    private static final Pattern APOS_PAT = Pattern.compile("'");

    public String applyLimitSql(Integer limit) {
        if (limit != null) {
            return "rownum <= " + limit;
        }
        return null;
    }

    public String getStrToDateFunction() {
        return "TO_DATE";
    }

    public String getCurTimeFunction() {
        return "sysdate";
    }

    public String getDateFormatString(String dateFormatString) {
        return "'" + dateFormatString + "'";
    }

    @Override
    protected Long getNextValSqlJdbc(String sequenceName, Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("select " + sequenceName + ".nextval from dual");
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new RuntimeException("Error retrieving next option id for action list from sequence.");
            }
            Long l = new Long(resultSet.getLong(1));
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving next option id for action list from sequence.", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    @Deprecated
    protected Long getNextValSqlOjb(String sequenceName, PersistenceBroker persistenceBroker) {
        try {
            Connection connection = persistenceBroker.serviceConnectionManager().getConnection();
            return this.getNextValSqlJdbc(sequenceName, connection);
        }
        catch (LookupException e) {
            throw new RuntimeException("Error retrieving next option id for action list from sequence.", e);
        }
    }

    public String getLockRouteHeaderQuerySQL(String documentId, boolean wait) {
        long timeoutSeconds = this.getTimeoutSeconds();
        String waitClause = "";
        if (!wait) {
            waitClause = " NOWAIT";
        } else if (wait && timeoutSeconds > 0L) {
            waitClause = " WAIT " + timeoutSeconds;
        }
        return "SELECT DOC_HDR_ID FROM KREW_DOC_HDR_T WHERE DOC_HDR_ID=? FOR UPDATE" + waitClause;
    }

    @Override
    public String toString() {
        return "[OracleDatabasePlatform]";
    }

    protected long getTimeoutSeconds() {
        String timeoutValue = ConfigContext.getCurrentContextConfig().getDocumentLockTimeout();
        if (timeoutValue != null) {
            try {
                return Long.parseLong(timeoutValue);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Failed to parse document lock timeout as it was not a valid number: " + timeoutValue));
            }
        }
        return 3600L;
    }

    public String getSelectForUpdateSuffix(long waitMillis) {
        String sql = "for update";
        if (-1L == waitMillis) {
            LOG.warn((Object)"Selecting for update and waiting forever...");
        } else if (0L == waitMillis) {
            sql = sql + " nowait";
        } else {
            long seconds = waitMillis / 1000L;
            if (seconds == 0L) {
                seconds = 1L;
            }
            sql = sql + " wait " + seconds;
        }
        return sql;
    }

    public String escapeString(String sqlString) {
        return sqlString != null ? APOS_PAT.matcher(sqlString).replaceAll("''") : null;
    }

    @Override
    public String getDateSQL(String date, String time) {
        String d = date.replace('/', '-');
        if (time == null) {
            return "{d '" + d + "'}";
        }
        return this.getStrToDateFunction() + "('" + d + " " + time + "', 'YYYY-MM-DD HH24:MI:SS')";
    }
}

