/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.uif.service.ViewDictionaryService;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.springframework.beans.PropertyAccessorUtils;

@Deprecated
@LegacyDataFramework
public class DataObjectMetaDataServiceImpl
implements DataObjectMetaDataService {
    private DataDictionaryService dataDictionaryService;
    private KualiModuleService kualiModuleService;
    private PersistenceStructureService persistenceStructureService;
    private ViewDictionaryService viewDictionaryService;

    @Override
    public List<String> listPrimaryKeyFieldNames(Class<?> clazz) {
        if (this.persistenceStructureService.isPersistable(clazz)) {
            return this.persistenceStructureService.listPrimaryKeyFieldNames(clazz);
        }
        ModuleService responsibleModuleService = this.getKualiModuleService().getResponsibleModuleService(clazz);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(clazz)) {
            return responsibleModuleService.listPrimaryKeyFieldNames(clazz);
        }
        List pks = this.dataDictionaryService.getDataDictionary().getDataObjectEntry(clazz.getName()).getPrimaryKeys();
        if (pks != null && !pks.isEmpty()) {
            return pks;
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject) {
        return this.getPrimaryKeyFieldValues(dataObject, false);
    }

    @Override
    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject, boolean sortFieldNames) {
        AbstractMap keyValueMap = sortFieldNames ? new TreeMap() : new HashMap();
        List<String> fields = this.listPrimaryKeyFieldNames(dataObject.getClass());
        for (String fieldName : fields) {
            keyValueMap.put(fieldName, ObjectPropertyUtils.getPropertyValue((Object)dataObject, (String)fieldName));
        }
        return keyValueMap;
    }

    @Override
    public boolean equalsByPrimaryKeys(Object do1, Object do2) {
        boolean equal = true;
        if (do1 == null && do2 == null) {
            equal = true;
        } else if (do1 == null || do2 == null) {
            equal = false;
        } else if (!do1.getClass().getName().equals(do2.getClass().getName())) {
            equal = false;
        } else {
            Map<String, ?> do1Keys = this.getPrimaryKeyFieldValues(do1);
            Map<String, ?> do2Keys = this.getPrimaryKeyFieldValues(do2);
            for (String keyName : do1Keys.keySet()) {
                if (do1Keys.get(keyName) != null && do2Keys.get(keyName) != null) {
                    if (do1Keys.get(keyName).toString().equals(do2Keys.get(keyName).toString())) continue;
                    equal = false;
                    continue;
                }
                equal = false;
            }
        }
        return equal;
    }

    @Override
    public DataObjectRelationship getDataObjectRelationship(Object dataObject, Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly, boolean supportsLookup, boolean supportsInquiry) {
        RelationshipDefinition ddReference = this.getDictionaryRelationship(dataObjectClass, attributeName);
        return this.getDataObjectRelationship(ddReference, dataObject, dataObjectClass, attributeName, attributePrefix, keysOnly, supportsLookup, supportsInquiry);
    }

    protected DataObjectRelationship getDataObjectRelationship(RelationshipDefinition ddReference, Object dataObject, Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly, boolean supportsLookup, boolean supportsInquiry) {
        DataObjectRelationship relationship = null;
        if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)attributeName)) {
            if (ddReference != null && this.classHasSupportedFeatures(ddReference.getTargetClass(), supportsLookup, supportsInquiry)) {
                relationship = this.populateRelationshipFromDictionaryReference(dataObjectClass, ddReference, attributePrefix, keysOnly);
                return relationship;
            }
            String localPrefix = StringUtils.substringBefore((String)attributeName, (String)".");
            String localAttributeName = StringUtils.substringAfter((String)attributeName, (String)".");
            if (dataObject == null) {
                try {
                    dataObject = KRADUtils.createNewObjectFromClass(dataObjectClass);
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
            Object nestedObject = ObjectPropertyUtils.getPropertyValue((Object)dataObject, (String)localPrefix);
            Class nestedClass = null;
            nestedClass = nestedObject == null ? ObjectPropertyUtils.getPropertyType((Object)dataObject, (String)localPrefix) : nestedObject.getClass();
            Object fullPrefix = localPrefix;
            if (StringUtils.isNotBlank((String)attributePrefix)) {
                fullPrefix = attributePrefix + "." + localPrefix;
            }
            relationship = this.getDataObjectRelationship(nestedObject, nestedClass, localAttributeName, (String)fullPrefix, keysOnly, supportsLookup, supportsInquiry);
            return relationship;
        }
        int maxSize = Integer.MAX_VALUE;
        if (this.getPersistenceStructureService().isPersistable(dataObjectClass)) {
            Map<String, DataObjectRelationship> rels = this.getPersistenceStructureService().getRelationshipMetadata(dataObjectClass, attributeName, attributePrefix);
            if (rels.size() > 0) {
                for (DataObjectRelationship rel : rels.values()) {
                    if (rel.getParentToChildReferences().size() >= maxSize || !this.classHasSupportedFeatures(rel.getRelatedClass(), supportsLookup, supportsInquiry)) continue;
                    maxSize = rel.getParentToChildReferences().size();
                    relationship = rel;
                }
            }
        } else {
            ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(dataObjectClass);
            if (moduleService != null && moduleService.isExternalizable(dataObjectClass)) {
                relationship = this.getRelationshipMetadata(dataObjectClass, attributeName, attributePrefix);
                if (relationship != null && this.classHasSupportedFeatures(relationship.getRelatedClass(), supportsLookup, supportsInquiry)) {
                    return relationship;
                }
                return null;
            }
        }
        if (ddReference != null && ddReference.getPrimitiveAttributes().size() < maxSize && this.classHasSupportedFeatures(ddReference.getTargetClass(), supportsLookup, supportsInquiry)) {
            relationship = this.populateRelationshipFromDictionaryReference(dataObjectClass, ddReference, null, keysOnly);
        }
        return relationship;
    }

    protected boolean classHasSupportedFeatures(Class relationshipClass, boolean supportsLookup, boolean supportsInquiry) {
        boolean hasSupportedFeatures = true;
        if (supportsLookup && !this.getViewDictionaryService().isLookupable(relationshipClass)) {
            hasSupportedFeatures = false;
        }
        if (supportsInquiry && !this.getViewDictionaryService().isInquirable(relationshipClass)) {
            hasSupportedFeatures = false;
        }
        return hasSupportedFeatures;
    }

    @Override
    public RelationshipDefinition getDictionaryRelationship(Class<?> c, String attributeName) {
        DataDictionaryEntry entryBase = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(c.getName());
        if (entryBase == null) {
            return null;
        }
        RelationshipDefinition relationship = null;
        List ddRelationships = entryBase.getRelationships();
        int minKeys = Integer.MAX_VALUE;
        block0: for (RelationshipDefinition def : ddRelationships) {
            if (def.getPrimitiveAttributes().size() == 1) {
                for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                    if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                    relationship = def;
                    minKeys = 1;
                    continue block0;
                }
                continue;
            }
            if (def.getPrimitiveAttributes().size() >= minKeys) continue;
            for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                relationship = def;
                minKeys = def.getPrimitiveAttributes().size();
                continue block0;
            }
        }
        if (relationship == null) {
            for (RelationshipDefinition def : ddRelationships) {
                if (!def.hasIdentifier() || !def.getIdentifier().getSourceName().equals(attributeName)) continue;
                relationship = def;
            }
        }
        return relationship;
    }

    protected DataObjectRelationship populateRelationshipFromDictionaryReference(Class<?> dataObjectClass, RelationshipDefinition ddReference, String attributePrefix, boolean keysOnly) {
        DataObjectRelationship relationship = new DataObjectRelationship(dataObjectClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
        for (PrimitiveAttributeDefinition def : ddReference.getPrimitiveAttributes()) {
            if (StringUtils.isNotBlank((String)attributePrefix)) {
                relationship.getParentToChildReferences().put(attributePrefix + "." + def.getSourceName(), def.getTargetName());
                continue;
            }
            relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
        }
        if (!keysOnly) {
            for (PrimitiveAttributeDefinition def : ddReference.getSupportAttributes()) {
                if (StringUtils.isNotBlank((String)attributePrefix)) {
                    relationship.getParentToChildReferences().put(attributePrefix + "." + def.getSourceName(), def.getTargetName());
                    if (!def.isIdentifier()) continue;
                    relationship.setUserVisibleIdentifierKey(attributePrefix + "." + def.getSourceName());
                    continue;
                }
                relationship.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
                if (!def.isIdentifier()) continue;
                relationship.setUserVisibleIdentifierKey(def.getSourceName());
            }
        }
        return relationship;
    }

    protected DataObjectRelationship getRelationshipMetadata(Class<?> dataObjectClass, String attributeName, String attributePrefix) {
        RelationshipDefinition relationshipDefinition = this.getDictionaryRelationship(dataObjectClass, attributeName);
        if (relationshipDefinition == null) {
            return null;
        }
        DataObjectRelationship dataObjectRelationship = new DataObjectRelationship(relationshipDefinition.getSourceClass(), relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
        if (!StringUtils.isEmpty((String)attributePrefix)) {
            attributePrefix = (String)attributePrefix + ".";
        }
        List primitives = relationshipDefinition.getPrimitiveAttributes();
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitives) {
            dataObjectRelationship.getParentToChildReferences().put((String)attributePrefix + primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
        }
        return dataObjectRelationship;
    }

    @Override
    public String getTitleAttribute(Class<?> dataObjectClass) {
        String titleAttribute = null;
        DataObjectEntry entry = this.getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            titleAttribute = entry.getTitleAttribute();
        }
        return titleAttribute;
    }

    @Override
    public boolean areNotesSupported(Class<?> dataObjectClass) {
        boolean hasNotesSupport = false;
        DataObjectEntry entry = this.getDataObjectEntry(dataObjectClass);
        if (entry != null) {
            hasNotesSupport = entry.isBoNotesEnabled();
        }
        return hasNotesSupport;
    }

    @Override
    public String getDataObjectIdentifierString(Object dataObject) {
        Object identifierString = "";
        if (dataObject == null) {
            identifierString = "Null";
            return identifierString;
        }
        Class<?> dataObjectClass = dataObject.getClass();
        if (PersistableBusinessObject.class.isAssignableFrom(dataObjectClass)) {
            String objectId = (String)ObjectPropertyUtils.getPropertyValue((Object)dataObject, (String)"objectId");
            if (StringUtils.isBlank((String)objectId)) {
                objectId = UUID.randomUUID().toString();
                ObjectPropertyUtils.setPropertyValue((Object)dataObject, (String)"objectId", (Object)objectId);
            }
            identifierString = objectId;
        } else {
            Map<String, ?> primaryKeyFieldValues = this.getPrimaryKeyFieldValues(dataObject, true);
            for (Map.Entry<String, ?> primaryKeyValue : primaryKeyFieldValues.entrySet()) {
                identifierString = primaryKeyValue.getValue() == null ? (String)identifierString + "Null" : (String)identifierString + String.valueOf(primaryKeyValue.getValue());
                identifierString = (String)identifierString + ":";
            }
            identifierString = StringUtils.removeEnd((String)identifierString, (String)":");
        }
        return identifierString;
    }

    protected DataObjectEntry getDataObjectEntry(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        DataObjectEntry entry = this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(dataObjectClass.getName());
        return entry;
    }

    @Override
    public List<DataObjectRelationship> getDataObjectRelationships(Class<?> dataObjectClass) {
        DataDictionaryEntry ddEntry;
        if (dataObjectClass == null) {
            return null;
        }
        Map<String, Class> referenceClasses = null;
        if (PersistableBusinessObject.class.isAssignableFrom(dataObjectClass) && this.getPersistenceStructureService().isPersistable(dataObjectClass)) {
            referenceClasses = this.getPersistenceStructureService().listReferenceObjectFields(dataObjectClass);
        }
        List ddRelationships = (ddEntry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(dataObjectClass.getName())) == null ? new ArrayList() : ddEntry.getRelationships();
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>();
        if (referenceClasses != null) {
            for (Map.Entry entry : referenceClasses.entrySet()) {
                if (!this.classHasSupportedFeatures((Class)entry.getValue(), true, false)) continue;
                Map fkToPkRefs = this.getPersistenceStructureService().getForeignKeysForReference(dataObjectClass, (String)entry.getKey());
                DataObjectRelationship rel = new DataObjectRelationship(dataObjectClass, (String)entry.getKey(), (Class)entry.getValue());
                for (Map.Entry ref : fkToPkRefs.entrySet()) {
                    rel.getParentToChildReferences().put((String)ref.getKey(), (String)ref.getValue());
                }
                relationships.add(rel);
            }
        }
        for (RelationshipDefinition relationshipDefinition : ddRelationships) {
            if (!this.classHasSupportedFeatures(relationshipDefinition.getTargetClass(), true, false)) continue;
            DataObjectRelationship rel = new DataObjectRelationship(dataObjectClass, relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
            for (PrimitiveAttributeDefinition def : relationshipDefinition.getPrimitiveAttributes()) {
                rel.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
            }
            relationships.add(rel);
        }
        return relationships;
    }

    @Override
    public boolean hasLocalLookup(Class<?> dataObjectClass) {
        return this.viewDictionaryService.isLookupable(dataObjectClass);
    }

    @Override
    public boolean hasLocalInquiry(Class<?> dataObjectClass) {
        return this.viewDictionaryService.isInquirable(dataObjectClass);
    }

    protected BusinessObjectEntry getBusinessObjectEntry(Class businessObjectClass) {
        this.validateBusinessObjectClass(businessObjectClass);
        BusinessObjectEntry entry = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName());
        return entry;
    }

    protected void validateBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (!BusinessObject.class.isAssignableFrom(businessObjectClass)) {
            throw new IllegalArgumentException("class '" + businessObjectClass.getName() + "' is not a descendant of BusinessObject");
        }
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected ViewDictionaryService getViewDictionaryService() {
        if (this.viewDictionaryService == null) {
            this.viewDictionaryService = KRADServiceLocatorWeb.getViewDictionaryService();
        }
        return this.viewDictionaryService;
    }

    public void setViewDictionaryService(ViewDictionaryService viewDictionaryService) {
        this.viewDictionaryService = viewDictionaryService;
    }
}

