/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.document.authorization;

import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public class BusinessObjectRestrictionsBase implements
		BusinessObjectRestrictions {
	private Map<String, MaskFormatter> partiallyMaskedFields;
	private Map<String, MaskFormatter> fullyMaskedFields;

	protected Set<String> allRestrictedFields;

	public BusinessObjectRestrictionsBase() {
		clearAllRestrictions();
	}

	@Override
    public boolean hasAnyFieldRestrictions() {
		return !partiallyMaskedFields.isEmpty() || !fullyMaskedFields.isEmpty();
	}

	@Override
    public boolean hasRestriction(String fieldName) {
		return isPartiallyMaskedField(fieldName) || isFullyMaskedField(fieldName);
	}

	@Override
    public void addFullyMaskedField(String fieldName,
                                    MaskFormatter maskFormatter) {
		fullyMaskedFields.put(fieldName, maskFormatter);
	}

	@Override
    public void addPartiallyMaskedField(String fieldName,
                                        MaskFormatter maskFormatter) {
		partiallyMaskedFields.put(fieldName, maskFormatter);
	}

	/**
	 * 
	 * This method returns the authorization setting for the given field name.
	 * If the field name is not restricted in any way, a default full-editable
	 * value is returned.
	 * 
	 * @param fieldName
	 *            - name of field to get authorization restrictions for.
	 * @return a populated FieldAuthorization class for this field
	 * 
	 */
	@Override
    public FieldRestriction getFieldRestriction(String fieldName) {
		if (hasRestriction(fieldName)) {
			FieldRestriction fieldRestriction = null;
			if (isPartiallyMaskedField(fieldName)) {
				fieldRestriction = new FieldRestriction(fieldName,
						Field.PARTIALLY_MASKED);
				fieldRestriction.setMaskFormatter(partiallyMaskedFields
						.get(normalizeFieldName(fieldName)));
			}
			if (isFullyMaskedField(fieldName)) {
				fieldRestriction = new FieldRestriction(fieldName, Field.MASKED);
				fieldRestriction.setMaskFormatter(fullyMaskedFields
						.get(normalizeFieldName(fieldName)));
			}
			return fieldRestriction;
		} else {
			return new FieldRestriction(fieldName, Field.EDITABLE);
		}
	}

	public void clearAllRestrictions() {
		partiallyMaskedFields = new HashMap<String, MaskFormatter>();
		fullyMaskedFields = new HashMap<String, MaskFormatter>();
		allRestrictedFields = null;
	}
	
	
	/**
	 * This method is used to convert field names on forms into a format that's compatible with field names
	 * that are registered with a restriction.  The base implementation of this method just returns the string.
	 * 
	 * @param fieldName The field name that would be rendered on a form
	 * @return
	 */
	protected String normalizeFieldName(String fieldName) {
		return fieldName;
	}
	
	protected boolean isFullyMaskedField(String fieldName) {
		String normalizedFieldName = normalizeFieldName(fieldName);
		return fullyMaskedFields.containsKey(normalizedFieldName);
	}
	
	protected boolean isPartiallyMaskedField(String fieldName) {
		String normalizedFieldName = normalizeFieldName(fieldName);
		return partiallyMaskedFields.containsKey(normalizedFieldName);
	}
}
