/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.struts.form.pojo;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.util.IncidentReportUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * This class is the exception handler for the base exception class java.lang.Throwable
 * and is defined as global exception in the struts-config.xml. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class StrutsExceptionIncidentHandler extends ExceptionHandler {
    private static final Logger LOG=
        LogManager.getLogger(StrutsExceptionIncidentHandler.class);
    
    /**
     * This is defined in struts-config.xml for forwarding this exception to a specified
     * exception handler.
     * <p>Value is exceptionIncidentHandler
     */
    public static final String EXCEPTION_INCIDENT_HANDLER="exceptionIncidentHandler";
    
    /**
     * This overridden method extract exception information such as component name,
     * user name and email, etc.
     * 
     * @see org.apache.struts.action.ExceptionHandler#execute(
     * java.lang.Exception,
     *  org.apache.struts.config.ExceptionConfig,
     *   org.apache.struts.action.ActionMapping,
     *    org.apache.struts.action.ActionForm,
     *     javax.servlet.http.HttpServletRequest,
     *      javax.servlet.http.HttpServletResponse)
     */
    @Override
    public ActionForward execute(Exception exception,
                                 ExceptionConfig exceptionConfig,
                                 ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response) {
        
        if (LOG.isTraceEnabled()) {
            String message=String.format("ENTRY %s", exception.getMessage());
            LOG.trace(message);
        }
        
        LOG.error("Exception being handled by Exception Handler", exception);

        String documentId="";
        if (form instanceof KualiDocumentFormBase) {
            KualiDocumentFormBase docForm=(KualiDocumentFormBase)form;
            if (docForm.getDocument() != null) {
            	documentId=docForm.getDocument().getDocumentNumber();
            }
        }
        
    String componentName = "unknown";
    if (form != null) {
      componentName = form.getClass().getSimpleName();
    }
    Map<String, String> properties = IncidentReportUtils
        .populateRequestForIncidentReport(exception, documentId, componentName, request);

        
        ActionForward forward=mapping.findForward(EXCEPTION_INCIDENT_HANDLER);
        
        if (LOG.isTraceEnabled()) {
            String message=String.format("ENTRY %s%n%s%n%s",
                    exception.getMessage(),
                    properties.toString(),
                    (forward==null)?"null":forward.getPath());
            LOG.trace(message);
        }

        return forward;
    }

}

