/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.core.framework.persistence.ojb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.OptimisticLockException;
import org.springframework.dao.OptimisticLockingFailureException;

/**
 * Provides some simple utilities for working with data access exceptions.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Deprecated
public final class DataAccessUtils {

    private static final Set<Class<? extends Throwable>> OPTIMISTIC_LOCK_EXCEPTION_CLASSES = new HashSet<Class<? extends Throwable>>();
    
        private DataAccessUtils() {
                throw new UnsupportedOperationException("do not call");
        }

    // add some standard optimistic lock exception classes
    static {
        addOptimisticLockExceptionClass(OptimisticLockException.class);
        addOptimisticLockExceptionClass(OptimisticLockingFailureException.class);
    }

    public static synchronized boolean isOptimisticLockFailure(Throwable exception) {
        if (exception == null) {
            return false;
        }
        for (final Class<?> exceptionClass : getOptimisticLockExceptionClasses()) {
            if (ExceptionUtils.indexOfType(exception, exceptionClass) >= 0) {
                return true;
            }
        }
        return false;
    }

    public static synchronized void addOptimisticLockExceptionClass(Class<? extends Throwable> exceptionClass) {
        OPTIMISTIC_LOCK_EXCEPTION_CLASSES.add(exceptionClass);
    }

    public static synchronized Set<Class<? extends Throwable>> getOptimisticLockExceptionClasses() {
        return Collections.unmodifiableSet(OPTIMISTIC_LOCK_EXCEPTION_CLASSES);
    }

}
