/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.web.ui;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.util.KRADConstants;

import java.io.Serializable;

/**
 * Represents an extra button that may appear on the lookups or bottom of a
 * document page.
 *
 * @deprecated KNS Struts deprecated, use KRAD and the Spring MVC framework.
 */
@Deprecated
public class ExtraButton implements Serializable {
	private String extraButtonSource = "";

	private String extraButtonLabel = "";

	private String extraButtonAltText = "";

	private String extraButtonParams = "";

	private String extraButtonProperty = "";

	private String extraButtonOnclick = "";

	public String getExtraButtonLabel() {
		return extraButtonLabel;
	}

	public void setExtraButtonLabel(String extraButtonLabel) {
		this.extraButtonLabel = extraButtonLabel;
	}

	public String getExtraButtonAltText() {
		return extraButtonAltText;
	}

	public void setExtraButtonAltText(String extraButtonAltText) {
		this.extraButtonAltText = extraButtonAltText;
	}

	public String getExtraButtonParams() {
		return extraButtonParams;
	}

	public void setExtraButtonParams(String extraButtonParams) {
		this.extraButtonParams = extraButtonParams;
	}

	public String getExtraButtonProperty() {
		return extraButtonProperty;
	}

	public void setExtraButtonProperty(String extraButtonProperty) {
		this.extraButtonProperty = extraButtonProperty;
	}

	public String getExtraButtonSource() {
		return extraButtonSource;
	}
	    
	public String getExtraButtonOnclick() {
	    return this.extraButtonOnclick;
	}
	 
	public void setExtraButtonOnclick(String extraButtonOnclick) {
	    this.extraButtonOnclick = extraButtonOnclick;
	}

	public void setExtraButtonSource(String extraButtonSource) {
		if (StringUtils.isNotBlank(extraButtonSource)) {
			this.extraButtonSource = extraButtonSource
					.replace("${kr.externalizable.images.url}",
							CoreApiServiceLocator
									.getKualiConfigurationService()
									.getPropertyValueAsString(KRADConstants.EXTERNALIZABLE_IMAGES_URL_KEY))
					.replace(
							"${externalizable.images.url}",
							CoreApiServiceLocator
									.getKualiConfigurationService()
									.getPropertyValueAsString(KRADConstants.APPLICATION_EXTERNALIZABLE_IMAGES_URL_KEY));
		}
	}

}
