/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.dao;

import java.util.List;
import java.util.Map;

import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.kuali.rice.krad.util.QueryPagingRequest;
import org.kuali.rice.krad.util.QueryPagingResults;

/**
 * This is the generic data access interface for business objects. This should be used for unit testing purposes only.
 * @deprecated use new KRAD Data framework {@link org.kuali.rice.krad.data.DataObjectService}
 */
@Deprecated
@LegacyDataFramework
public interface BusinessObjectDao {
    /**
     * Saves any object that implements the BusinessObject interface.
     */
    <T extends PersistableBusinessObject> T save(T bo);

    /**
     * Saves a List of BusinessObjects.
     */
    <T extends PersistableBusinessObject> List<T> save(List<T> businessObjects);

    /**
     * Retrieves an object instance identified by its primary key. For composite keys, use {@link #findByPrimaryKey(Class, Map)}
     */
    <T extends PersistableBusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey);
    
    /**
     * Retrieves an object instance identified bys it primary keys and values. This can be done by constructing a map where the key
     * to the map entry is the primary key attribute and the value of the entry being the primary key value. For composite keys,
     * pass in each primaryKey attribute and its value as a map entry.
     */
    <T extends PersistableBusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys);
    
    /**
	 * Retrieves an object, based on its PK object
	 * 
	 * @param clazz the class of the object to retrieve
	 * @param pkObject the value of the primary key
	 * @return the retrieved PersistableBusinessObject
	 */
	<T extends PersistableBusinessObject> T findByPrimaryKeyUsingKeyObject(Class<T> clazz, Object pkObject);

    /**
     * Retrieves an object instance identified by the class of the given object and the object's primary key values.
     */
    Object retrieve(Object object);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type.
     */
    <T extends PersistableBusinessObject> List<T> findAll(Class<T> clazz);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAll(Class<T> clazz, QueryPagingRequest pagingRequest);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type.
     * 
     * Adds criteria on active column to return only active records. Assumes there exist a mapping for PropertyConstants.Active
     */
    <T extends PersistableBusinessObject> List<T> findAllActive(Class<T> clazz);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAllActive(Class<T> clazz, QueryPagingRequest pagingRequest);

    <T extends PersistableBusinessObject> List<T> findAllInactive(Class<T> clazz);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAllInactive(Class<T> clazz, QueryPagingRequest pagingRequest);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type. Orders the results by the given field.
     */
    <T extends PersistableBusinessObject> List<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest);

    /**
     * Retrieves a collection of business objects populated with data, such that each record in the database populates a new object
     * instance. This will only retrieve business objects by class type. Orders the results by the given field.
     * 
     * Adds criteria on active column to return only active records. Assumes there exist a mapping for PropertyConstants.Active
     */
    <T extends PersistableBusinessObject> List<T> findAllActiveOrderBy(Class<T> clazz, String sortField, boolean sortAscending);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findAllActiveOrderBy(Class<T> clazz, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest);

    /**
     * This method retrieves a collection of business objects populated with data, such that each record in the database populates a
     * new object instance. This will retrieve business objects by class type and also by criteria passed in as key-value pairs,
     * specifically attribute name-expected value.
     */
    <T extends PersistableBusinessObject> List<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest);

    /**
     * This method retrieves a collection of business objects populated with data, such that each record in the database populates a
     * new object instance. This will retrieve business objects by class type and also by criteria passed in as key-value pairs,
     * specifically attribute name-expected value.
     * 
     * Adds criteria on active column to return only active records. Assumes there exist a mapping for PropertyConstants.Active
     */
    <T extends PersistableBusinessObject> List<T> findMatchingActive(Class<T> clazz, Map<String, ?> fieldValues);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findMatchingActive(Class<T> clazz, Map<String, ?> fieldValues, QueryPagingRequest pagingRequest);

    /**
     * @return count of BusinessObjects of the given class whose fields match the values in the given Map.
     */
    <T extends PersistableBusinessObject> int countMatching(Class<T> clazz, Map<String, ?> fieldValues);
    
    /**
     * 
     * This method returns the number of matching result given the positive criterias and
     * negative criterias. The negative criterias are the ones that will be set to 
     * "notEqualTo" or "notIn"
     * 
     * @param positiveFieldValues  Map of fields and values for positive criteria
     * @param negativeFieldValues  Map of fields and values for negative criteria
     */
    <T extends PersistableBusinessObject> int countMatching(Class<T> clazz, Map<String, ?> positiveFieldValues, Map<String, ?> negativeFieldValues);

    /**
     * This method retrieves a collection of business objects populated with data, such that each record in the database populates a
     * new object instance. This will retrieve business objects by class type and also by criteria passed in as key-value pairs,
     * specifically attribute name-expected value. Orders the results by the given field.
     */
    <T extends PersistableBusinessObject> List<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending);
    <T extends PersistableBusinessObject> QueryPagingResults<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending, QueryPagingRequest pagingRequest);

    /**
     * Deletes a business object from the database.
     */
    void delete(Object bo);

    /**
     * Deletes each business object in the given List from the database.
     */
    <T extends PersistableBusinessObject> void delete(List<T> boList);

    /**
     * Deletes the business objects matching the given fieldValues
     */
    <T extends PersistableBusinessObject> void deleteMatching(Class<T> clazz, Map<String, ?> fieldValues);
    
    /**
     * Merges the given business object, but tells the ORM that the object is to be treated as Read Only,
     * and even if it has changes, it will not be persisted to the database 
     * 
     * @param bo the business object to managed
     * @return the managed copied of the business object
     */
    <T extends PersistableBusinessObject> T manageReadOnly(T bo);
}
