/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.io.IOException;
import java.io.InputStream;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBaseAdapter;
import org.kuali.rice.krad.service.KRADServiceLocator;

@Entity
@Table(name="KRNS_ATT_T", uniqueConstraints={@UniqueConstraint(name="KRNS_ATT_TC0", columnNames={"OBJ_ID"})})
public class Attachment
extends PersistableBusinessObjectBaseAdapter
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 402432724949441326L;
    @Id
    @Column(name="NTE_ID", length=14, precision=0, updatable=false)
    private Long noteIdentifier;
    @Column(name="MIME_TYP", length=255)
    private String attachmentMimeTypeCode;
    @Column(name="FILE_NM", length=250)
    private String attachmentFileName;
    @Column(name="ATT_ID", length=36)
    private String attachmentIdentifier;
    @Column(name="FILE_SZ", length=14, precision=0)
    private Long attachmentFileSize;
    @Column(name="ATT_TYP_CD", length=40)
    private String attachmentTypeCode;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.REFRESH, CascadeType.DETACH})
    @JoinColumn(name="NTE_ID", updatable=false, insertable=false)
    private Note note;

    public Long getNoteIdentifier() {
        return this._persistence_get_noteIdentifier();
    }

    public void setNoteIdentifier(Long noteIdentifier) {
        this._persistence_set_noteIdentifier(noteIdentifier);
    }

    public String getAttachmentMimeTypeCode() {
        return this._persistence_get_attachmentMimeTypeCode();
    }

    public void setAttachmentMimeTypeCode(String attachmentMimeTypeCode) {
        this._persistence_set_attachmentMimeTypeCode(attachmentMimeTypeCode);
    }

    public String getAttachmentFileName() {
        return this._persistence_get_attachmentFileName();
    }

    public void setAttachmentFileName(String attachmentFileName) {
        this._persistence_set_attachmentFileName(attachmentFileName);
    }

    public String getAttachmentIdentifier() {
        return this._persistence_get_attachmentIdentifier();
    }

    public void setAttachmentIdentifier(String attachmentIdentifier) {
        this._persistence_set_attachmentIdentifier(attachmentIdentifier);
    }

    public Long getAttachmentFileSize() {
        return this._persistence_get_attachmentFileSize();
    }

    public void setAttachmentFileSize(Long attachmentFileSize) {
        this._persistence_set_attachmentFileSize(attachmentFileSize);
    }

    public String getAttachmentFileSizeWithUnits() {
        if (this._persistence_get_attachmentFileSize() != null) {
            return RiceUtilities.getFileSizeUnits((Long)this._persistence_get_attachmentFileSize());
        }
        return "";
    }

    public String getAttachmentTypeCode() {
        return this._persistence_get_attachmentTypeCode();
    }

    public void setAttachmentTypeCode(String attachmentTypeCode) {
        this._persistence_set_attachmentTypeCode(attachmentTypeCode);
    }

    public Note getNote() {
        return this._persistence_get_note();
    }

    public void setNote(Note note) {
        this._persistence_set_note(note);
    }

    public boolean isComplete() {
        return StringUtils.isNotBlank((String)this._persistence_get_attachmentIdentifier()) && StringUtils.isNotBlank((String)this._persistence_get_attachmentFileName()) && this._persistence_get_attachmentFileSize() != null && StringUtils.isNotBlank((String)this._persistence_get_attachmentMimeTypeCode());
    }

    public InputStream getAttachmentContents() throws IOException {
        return KRADServiceLocator.getAttachmentService().retrieveAttachmentContents(this);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Attachment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "attachmentTypeCode") {
            return this.attachmentTypeCode;
        }
        if (string == "attachmentFileSize") {
            return this.attachmentFileSize;
        }
        if (string == "attachmentMimeTypeCode") {
            return this.attachmentMimeTypeCode;
        }
        if (string == "attachmentFileName") {
            return this.attachmentFileName;
        }
        if (string == "attachmentIdentifier") {
            return this.attachmentIdentifier;
        }
        if (string == "note") {
            return this.note;
        }
        if (string == "noteIdentifier") {
            return this.noteIdentifier;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "attachmentTypeCode") {
            this.attachmentTypeCode = (String)object;
            return;
        }
        if (string == "attachmentFileSize") {
            this.attachmentFileSize = (Long)object;
            return;
        }
        if (string == "attachmentMimeTypeCode") {
            this.attachmentMimeTypeCode = (String)object;
            return;
        }
        if (string == "attachmentFileName") {
            this.attachmentFileName = (String)object;
            return;
        }
        if (string == "attachmentIdentifier") {
            this.attachmentIdentifier = (String)object;
            return;
        }
        if (string == "note") {
            this.note = (Note)object;
            return;
        }
        if (string == "noteIdentifier") {
            this.noteIdentifier = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_attachmentTypeCode() {
        this._persistence_checkFetched("attachmentTypeCode");
        return this.attachmentTypeCode;
    }

    public void _persistence_set_attachmentTypeCode(String string) {
        this._persistence_checkFetchedForSet("attachmentTypeCode");
        this._persistence_propertyChange("attachmentTypeCode", this.attachmentTypeCode, string);
        this.attachmentTypeCode = string;
    }

    public Long _persistence_get_attachmentFileSize() {
        this._persistence_checkFetched("attachmentFileSize");
        return this.attachmentFileSize;
    }

    public void _persistence_set_attachmentFileSize(Long l) {
        this._persistence_checkFetchedForSet("attachmentFileSize");
        this._persistence_propertyChange("attachmentFileSize", this.attachmentFileSize, l);
        this.attachmentFileSize = l;
    }

    public String _persistence_get_attachmentMimeTypeCode() {
        this._persistence_checkFetched("attachmentMimeTypeCode");
        return this.attachmentMimeTypeCode;
    }

    public void _persistence_set_attachmentMimeTypeCode(String string) {
        this._persistence_checkFetchedForSet("attachmentMimeTypeCode");
        this._persistence_propertyChange("attachmentMimeTypeCode", this.attachmentMimeTypeCode, string);
        this.attachmentMimeTypeCode = string;
    }

    public String _persistence_get_attachmentFileName() {
        this._persistence_checkFetched("attachmentFileName");
        return this.attachmentFileName;
    }

    public void _persistence_set_attachmentFileName(String string) {
        this._persistence_checkFetchedForSet("attachmentFileName");
        this._persistence_propertyChange("attachmentFileName", this.attachmentFileName, string);
        this.attachmentFileName = string;
    }

    public String _persistence_get_attachmentIdentifier() {
        this._persistence_checkFetched("attachmentIdentifier");
        return this.attachmentIdentifier;
    }

    public void _persistence_set_attachmentIdentifier(String string) {
        this._persistence_checkFetchedForSet("attachmentIdentifier");
        this._persistence_propertyChange("attachmentIdentifier", this.attachmentIdentifier, string);
        this.attachmentIdentifier = string;
    }

    public Note _persistence_get_note() {
        this._persistence_checkFetched("note");
        return this.note;
    }

    public void _persistence_set_note(Note note) {
        this._persistence_checkFetchedForSet("note");
        this._persistence_propertyChange("note", this.note, note);
        this.note = note;
    }

    public Long _persistence_get_noteIdentifier() {
        this._persistence_checkFetched("noteIdentifier");
        return this.noteIdentifier;
    }

    public void _persistence_set_noteIdentifier(Long l) {
        this._persistence_checkFetchedForSet("noteIdentifier");
        this._persistence_propertyChange("noteIdentifier", this.noteIdentifier, l);
        this.noteIdentifier = l;
    }
}

